@extends('LifeAtGainup.Navbar.header')

@section('title', 'Operation DETAILS')

@section('content')
<style>
   /*TAble popup*/
  
.status-container {
    display: flex;
    justify-content: flex-end; /* Pushes the status boxes to the end of the container */
    gap: 10px;
}

.status-box {
    width: 100px;
    height: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    color: #fff;
    font-weight: bold;
    border-radius: 5px;
}

.pending {
    background-color: red;
}

.done {
    background-color: green;
}

.late {
    background-color: orange;
}


   @media screen and (min-device-width: 1000px) and (max-device-width: 2400px) {

   .modal-contentt {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 50%;
    margin-left: 25%;
    color: var(--bs-modal-color);
    pointer-events: auto;
    background-color: var(--bs-modal-bg);
    background-clip: padding-box;
    border: var(--bs-modal-border-width) solid var(--bs-modal-border-color);
    border-radius: var(--bs-modal-border-radius);
    outline: 0;
}
   }
   @media screen and (min-device-width: 3px) and (max-device-width: 900px) {
    .modal-contentt {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 100%;

    color: var(--bs-modal-color);
    pointer-events: auto;
    background-color: var(--bs-modal-bg);
    background-clip: padding-box;
    border: var(--bs-modal-border-width) solid var(--bs-modal-border-color);
    border-radius: var(--bs-modal-border-radius);
    outline: 0;

}
   }
   .countBadge {
    position: absolute;
    top: -4px;
    right: -4px;
    background-color: red;
    color: white;
    border-radius: 50%;
    padding: 0px 2px;
    font-size: 8px;
    font-weight: bold;
        }
.caro_wid{

    width: 500px;
    height: 300px;
}
.caro_wid_center{
    justify-content: center;
    align-items: center;
    display: flex;
}

   .carousel-control-prev-icon,
.carousel-control-next-icon {
    background-color: red; /* Sets the background color to red */
    /* If you want to change the icon color itself, you may need to use a different approach depending on your setup */
}

.carousel-control-prev-icon,
.carousel-control-next-icon {
    /* For custom icons or to ensure proper visibility */
    background-size: 100%, 100%; /* Adjust if necessary */
    background-repeat: no-repeat;
    background-position: center;
}

.carousel-control-prev-icon:before,
.carousel-control-next-icon:before {
    /* Set a color for icons if they are font icons */
    color: red; /* This will work if icons are font icons like from FontAwesome */
}

   table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting_asc_disabled, table.dataTable thead>tr>th.sorting_desc_disabled, table.dataTable thead>tr>td.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting_asc_disabled, table.dataTable thead>tr>td.sorting_desc_disabled {

 padding-right: 17px;
}
.greencolor, .greencolor td{
    background-color: #ff0d0d33 !important;
}
   .header-fixed {
                            position: sticky;
                            top: 0px;
                            background-color: white;
                          }
   .table_popup{
        font-size: 11px !important;
    }
    .modal_popup{
        max-width: 1250px !important;
    }

    .ocrstatuscon {
        max-height: 400px;
        overflow-y: auto;
        overflow-x: auto;
    }

    .ocrstatus {
        width: 100%;
        border-collapse: collapse;
    }

    .ocrstatus thead th {
        position: sticky;
        top: 0;
        background-color: #fff;
        z-index: 10;
    }

    .ocrstatus th,
    .ocrstatus td {
        white-space: nowrap;
        text-align: center;
    }

    .sideallign{
        text-align: end !important;
    }

    .dt-button.buttons-pdf,
        .dt-button.buttons-html5 {
            padding: 2px 9px !important;
        }

    table.dataTable.no-footer{
        border-top: 1px solid rgba(0, 0, 0, 0.3);
    }
    table.dataTable{
        border-top: 1px solid rgba(0, 0, 0, 0.3);
        border-bottom: 1px solid rgba(0, 0, 0, 0.3);
    }


    table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting_asc_disabled, table.dataTable thead>tr>th.sorting_desc_disabled, table.dataTable thead>tr>td.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting_asc_disabled, table.dataTable thead>tr>td.sorting_desc_disabled {
        padding-right:17px !important;
    }

    .budget_abstract{
        width: 700px !important;
    font-size: 14px !important;
    }

    #noteText{
        color: blue !important;
    }
    .table_popup thead th {
    font-weight: bold;
}

.table_popup tfoot td {
    font-weight: bold;
}

.highlight-yellow {
    background-color: #deef636b !important; 
}
tr.highlight-next td {
    background-color: #93ff8f45 !important; 
  
        }
.highlight-green {
    background-color: #93ff8f45 !important; 
}

.highlight-red {
    background-color: #eea0936b !important; 
}

#dataTablee_wrapper .dt-buttons {
    margin-left: 15px;
    margin-top: 48px;
}

.centerallign{
    text-align: center !important;
}
#operationlist td:nth-child(4) {
    text-align: left;
}

div.dt-buttons {float: left;margin-top: 35px;}

.form-check-input {
        width: .6rem; /* Adjust width */
        height: .6rem; /* Adjust height */        
    }

.fade-out {
            animation: fadeOut 0.5s forwards;
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }
            to {
                opacity: 0;
            }
        }
    /* Your existing styles */
</style>

<div id="layout-wrapper">
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="card">
                            <div class="card-header  h-100">
                            <div class="row">
                                    <div class="col-md-6">
                                       Garments-Operation Details
                                    </div>
                                   
                                </div>

                            </div>
                            <div class="card-body">
                            <form id="filterForm">
                                    <div class="row">
                                        <!-- DIVISION -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="unit_name" class="form-label">Unit Name</label>
                                                <select class="form-control " name="unit_name" id="unit_name">
                                                <option value="">--Select Unit Name--</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="buyer_ocn" class="form-label">Buyer Name</label>
                                                <select class="form-control " name="buyer_ocn" id="buyer_ocn">
                                                <option value="">--Select Buyer Name--</option>
                                                </select>
                                            </div>
                                        </div>

                                        <!-- BUYER PO / REF NO. -->
                                      

                                    <!-- OCN NO. -->
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="ocn_no" class="form-label">OCN NO.</label>
                                                <select class="form-control " name="ocn_no" id="ocn_no">
                                                    <option value="">--Select OCN NO--</option>
                                                    <!-- OCN options will be populated dynamically based on selected buyer -->
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="status_op" class="form-label">Production Status.</label>
                                                <select class="form-control " name="status_op" id="status_op">
                                                    <option value="">--Select Status--</option>
                                                    <!-- OCN options will be populated dynamically based on selected buyer -->
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                   
                                   
                                        
                                        <input type="hidden" name="emp_id" id="emp_id"  value="{{$user = Session('empl_id')}}" >
                                        
                                  

                                    <!-- Submit Button -->
                                    <div class="row mt-3">
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary">Filter</button>
                                            <button type="button" id="resetButton" class="btn btn-secondary">Reset</button>

                                        </div>
                                        <div id="preloder">
                                            <div class="lds-hourglass">

                                            </div>
                                    </div>
                                 

                                </form>

                                <div class="table-responsive  table-card"  style="max-height:530px; ">
                                    <table class="table table-hover table-centered align-middle" id="operationlist">
                                        <thead class="text-muted table-light" style="font-size: 11px;">
                                            <tr>
                                            
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Unit
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">BuyerOCN
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Style
                                                </th>
                                              
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Order Qty
                                                </th>
                                               
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Ship Qty
                                                </th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">CK Date</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">File Status</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Ship Dt</th>
                                               
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Suppl PO</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Cut Pend</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">ACK Pend</th>

                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">SM Stock</th>
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">N2</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">N1</th>
                                                
                                               
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Overall Output</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Input Qty</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Output Qty</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;"> WIP Qty</th>
                                                <th style="position: sticky; top: 0; background: white; z-index: 10;">Prod Status</th>
                                              
                                            </tr>
                                        </thead>
                                        <tbody style="font-size: 11px">
                                            <!-- Data will be loaded here via AJAX -->
                                           
                                        </tbody>
                                        <tfoot style="font-size: 11px;">
                                            <tr>
                                                <th colspan="3">Total <span style="color:red">(in Lakhs)</span></th>
                                                <th id="totalOrdQty"></th>
                                                <th id="totalShipQty"></th>
                                                <th colspan="4"></th>                                                
                                                <th id="totalBalToIssQty"></th>
                                                <th id="totalBomQty"></th>
                                                <th id="totalSMstockQty"></th>
                                                <th id="totalN2Qty"></th>
                                                <th id="totalN1Qty"></th>
                                                <th id="totalOverAllQty"></th>
                                                <th id="totalInputQty"></th>
                                                <th id="totalOutputQty"></th>
                                                <th id="totalWIPQty"></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>






<div class="modal fade" id="tableModalbuyer" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabel">Buyer Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="table-container buyerorder">

            <div class="row">
                    <div class="col-md-3 mb-3">
                        <select id="itemDropdownbuyer" class="form-select">
                            <option value="">Select Item</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <select id="colorDropdownbuyer" class="form-select">
                            <option value="">Select Color</option>
                        </select>
                    </div>
                   
                    
                    
                </div>
            <table class="table table-bordered table_popup buyerorder" id ='buyerorder'>
                <thead class="header-fixed">
                    <tr>
                   
                    <tr>
                        <!-- Cutting Section -->
                        <th>SNo</th>
                        <th>Operation</th>
                        <th>Machine Type</th>
                        <th>OB Chart</th>
                        <th>Grade</th>
                        <th>Seconds</th>
                        <th>Mins</th>
                        <!-- Printing Section -->
                        <th>Req Oper</th>
                        <th>Allot Oper</th>
                        <th>Cost</th>
                        <th>Color</th>
                        <th>Item</th>
                       
                    </tr>
                </thead>
                <tbody>
                   
                </tbody>

                <tfoot style="font-size: 11px;">
                                            <tr>
                                                <th colspan="5">Total </th>
                                                <th id="totalseconds"></th>
                                                <th id="totalminis"></th>
                                                                                          
                                                <th id="totalreqoper"></th>
                                                <th id="totalalloper"></th>
                                                <th id="totalcost"></th>
                                               
                                                <th colspan="2"> </th>
                                            </tr>
                                        </tfoot>
            </table>
            </div>

            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>

<div class="modal fade" id="tableModalwip" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabel">WIP Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="table-container wipdetails">

            <div class="row">
                    <div class="col-md-3 mb-3">
                        <select id="itemDropdownwip" class="form-select">
                            <option value="">Select Item</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <select id="colorDropdowncolor" class="form-select">
                            <option value="">Select Color</option>
                        </select>
                    </div>
                   
                    
                    
                </div>
            <table class="table table-bordered table_popup wipdetails" id ='wipdetails'>
                <thead class="header-fixed">
                    <tr>
                   
                    <tr>
                        <!-- Cutting Section -->
                        <th>SNo</th>
                        
                        <th>Color</th>
                        <th>Item</th>
                        <th>Size</th>
                        <th> Input</th>
                        <th> Output</th>
                        <th>WIP</th>
                       
                    </tr>
                </thead>
                <tbody>
                   
                </tbody>

                <tfoot style="font-size: 11px;">
                                            <tr>
                                                <th colspan="3">Total </th>
                                                <th id="totalinput"></th>
                                                <th id="totaloutput"></th>
                                                                                          
                                                <th id="totalwip"></th>
                                                
                                            </tr>
                                        </tfoot>
            </table>
            </div>

            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>


<div class="modal fade" id="tableModalnotification" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-contentt">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabel">Notification Status  <span id="notifyocn"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-container ocrstatuscon">
                    <table class="table table-bordered table_popup ocrstatus">
                        <thead class="header-fixed">
                            <tr>
                                <th>S.No</th>
                                <th>MODE</th>
                                <th>TARGET DATE</th>
                                <th>ALERT DATE</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be dynamically inserted here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="buttonpopup" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-contentt">
            <div class="modal-header">
                <h5 class="modal-title" id="buttonpopup">OCR Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Form starts here -->
                <form id="ocrForm" method="POST" action="your_form_submission_url_here">
                    <div class="table-container ocrstatuscon">
                        <input type="hidden" id="master_id" name="master_id" value="">
                        <div class="mb-3">
                            <label for="ocrMessage" class="form-label">Message</label>
                            <textarea class="form-control" id="ocrMessage" name="ocrMessage" rows="3" placeholder="Enter your message" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
                <!-- Form ends here -->
                <div id="remarkcon">
                    </div>
            </div>
        </div>
    </div>
</div>





<!--T & A popup-->
<div class="modal fade" id="tableModalta" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabelta"></h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <table class="table table-bordered table_popup ta">
                <thead class="header-fixed">
                    <tr>
                        <th>S.No</th>
                        <th>TYPE</th>
                        <th>TASK</th>
                        <th>QTY</th>
                        <th>START DATE</th>
                        <th>FINISH DATE</th>
                        <th>ACTUAL QTY</th>
                        <th>ACTUAL DATE</th>
                        <th>ACTUAL FDATE</th>
                        <th>RESOURCES</th>
                        <th>DURATION</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3" class="sideallign">Total QTY:</th>
                        <th id="totalQty" class="sideallign"></th>
                        <th colspan="7"></th>
                    </tr>
                </tfoot>
            </table>

            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>

<!--Processing PO popup-->
<div class="modal fade" id="tableModalFileStatus" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="tableModalLabelFileStatus"></h5>            
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        
        <div class="modal-body">
                <div class="row"><div class="col-8">
                <h6>Process PO Summary Details:</h6>
                <table class="table table-bordered table_popup table_filestatus" id="FileStatusabstractTable">
                    <thead class="header-fixed">
                        <tr>
                            <th>Supplier</th>
                            <th>Process</th>
                            <th>PO Qty</th>
                            <th>GRN Qty</th>
                            <th>Bal Qty</th>
                            <th>Bal Per(%)</th>                        
                        </tr>                    
                    </thead>
                    <tbody> 
                    </tbody>
                    <tfoot>                       
                    </tfoot>
                </table>
                </div></div>
                <div class="mt-3">
                <h6>PROCESS PO ITEM DETAILS:</h6>
                </div>
                
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <select id="SupDropdownPO" class="form-select">
                            <option value="">Select Supplier</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <select id="ProDropdownPO" class="form-select">
                            <option value="">Select Process</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <select id="itemDropdownPO" class="form-select">
                            <option value="">Select Item</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <select id="colorDropdownPO" class="form-select">
                            <option value="">Select Color</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <select id="sizeDropdownPO" class="form-select">
                            <option value="">Select Size</option>
                        </select>
                    </div>
                </div>
                <table class="table table-bordered table_popup table_filestatus" id="ProcessItemdetailsTable">
                    <thead class="header-fixed">
                    <tr>
                        <th>Supplier</th>
                        <th>Process</th>
                        <th>Item</th>
                        <th>Color</th>
                        <th>Size</th>
                        <th>PO Qty</th>
                        <th>GRN Qty</th>
                        <th>Bal Qty</th>
                        <th>Bal Per(%)</th>                       
                    </tr>                    
                    </thead>
                    <tbody>
 
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="5" class="sideallign">Total:</th>
                            <th id="totalOrQtyPo" class="sideallign"></th>
                            <th id="totalBomQtyPo" class="sideallign"></th>
                            <th id="totalCutQtyPo" class="sideallign"></th>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>

<!--Buyer po popup-->
<div class="modal fade" id="tableModalBuyerpo" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabelBuyerpo"></h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table_popup" id="buyerpotable">
                    <thead></thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<!--supplier po popup-->
<div class="modal fade" id="tableModalpo" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabelpo"></h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table_popup">
                    <thead class="header-fixed">
                        <tr>
                            <th>S.No</th>
                            <th>ITEM</th>
                            <th>ITEM TYPE</th>
                            <th>COLOR</th>
                            <th>SIZE</th>
                            <th>REQ_QTY</th>
                            <th>GRN_QTY</th>
                            <th>TO BE ORD</th>
                            <th>TO BE RCVD</th>
                            <th>ISSUED</th>
                            <th>STOCK</th>
                            <th>SUPPLIER</th>
                            <th>PO NO</th>
                            <th>PO DATE</th>
                            <th>PLAN DATE</th>
                            <th>PO QTY</th>

                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="5" class="sideallign">Total</th>
                            <th id="Req_Qty" class="sideallign"></th>
                            <th id="Grn_Qty" class="sideallign"></th>
                            <th id="To_Be_Ord" class="sideallign"></th>
                            <th id="To_Be_Rcvd" class="sideallign"></th>
                            <th id="Issued" class="sideallign"></th>
                            <th id="Stock" class="sideallign"></th>
                            <th colspan="4"></th>
                            <th id="Po_Qty" class="sideallign"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>


<!--Production popup-->
<div class="modal fade" id="tableModalproduction" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="tableModalLabelproduction"></h5>
            <span id="noteText" class="ms-3"></span>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        
        <div class="modal-body">
                <h6>PRODUCTION ABSTRACT:</h6>
                <table class="table table-bordered table_popup table_production" id="abstractTable">
                    <thead class="header-fixed">
                    <tr>
                        <th rowspan="2">S.No</th>
                        <th rowspan="2">ITEM</th>
                        <th rowspan="2">COLOR</th>
                        <th rowspan="2">ORDER</th>
                        <th rowspan="2">BOM</th>
                        <th colspan="2" class="centerallign">CUTTING</th>
                        <th colspan="2" class="centerallign">LINE INPUT</th>
                        <th colspan="4" class="centerallign">LINE OUTPUT</th>
                        <th colspan="6" class="centerallign">FINISHING</th>
                       
                    </tr>
                    <tr>
                        <!--  CUTTING -->
                        <th>QTY</th>
                        <th>PENDING</th>
                        <!-- LINE INPUT -->
                        <th>QTY</th>
                        <th>PENDING</th>
                        <!-- LINE OUTPUT -->
                        <th>QTY</th>
                        <!-- <th>PENDING</th> -->
                        <th>REJ</th>
                        <th>WIP</th>
                        <th>REJ%</th>
                        <!-- FINISHING -->
                        <th>PCKED</th>
                        <th>PCK PEND</th>
                        <th>SHIPPED</th>
                        <th>SHIP PEND</th>
                        <th>TFR IN</th>
                        <th>TFR OUT</th>
                    </tr>
                    </thead>
                    <tbody>
 
                    </tbody>
                    <tfoot>
                        <tr>
                        <th colspan="3" class="sideallign">Total:</th>
                            <th id="abtotalQty" class="sideallign"></th>
                            <th id="abtotalBomQty" class="sideallign"></th>
                            <th id="abtotalCutQty" class="sideallign"></th>
                            <th id="abtotalToBeCut" class="sideallign"></th>
                            <th id="abtotalLineInput" class="sideallign"></th>
                            <th id="abtotalCutVsInp" class="sideallign"></th>
                            <th id="abtotalSewQty" class="sideallign"></th>
                            <th id="abtotalRejQty" class="sideallign"></th>
                            <th id="abtotalInpVsOutp" class="sideallign"></th>
                            <th colspan="1" class="sideallign"></th>
                            <th id="abtotalPckedQty" class="sideallign"></th>
                            <th id="abtotalAckVsPck" class="sideallign"></th>
                            <th id="abtotalShippedQty" class="sideallign"></th>
                            <th id="abtotalPckVsShip" class="sideallign"></th>
                            <th id="abtotalStockIn" class="sideallign"></th>
                            <th id="abtotalStockOut" class="sideallign"></th>
                        </tr>
                    </tfoot>
                </table>
                <div class="mt-3">
                <h6>PRODUCTION DETAILS:</h6>
                </div>
                
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <select id="itemDropdown" class="form-select">
                            <option value="">Select Item</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <select id="colorDropdown" class="form-select">
                            <option value="">Select Color</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <select id="sizeDropdown" class="form-select">
                            <option value="">Select Size</option>
                        </select>
                    </div>
                </div>
                <table class="table table-bordered table_popup table_production" id="detailsTable">
                    <thead class="header-fixed">
                    <tr>
                        <th rowspan="2">S.No</th>
                        <th rowspan="2">ITEM</th>
                        <th rowspan="2">COLOR</th>
                        <th rowspan="2">SIZE</th>
                        <th rowspan="2">ORDER</th>
                        <th rowspan="2">BOM</th>
                        <th colspan="2" class="centerallign">CUTTING</th>
                        <th colspan="2" class="centerallign">LINE INPUT</th>
                        <th colspan="4" class="centerallign">LINE OUTPUT</th>
                        <th colspan="6" class="centerallign">FINISHING</th>
                       
                    </tr>
                    <tr>
                        <!--  CUTTING -->
                        <th>QTY</th>
                        <th>PENDING</th>
                        <!-- LINE INPUT -->
                        <th>QTY</th>
                        <th>PENDING</th>
                        <!-- LINE OUTPUT -->
                        <th>QTY</th>
                        <!-- <th>PENDING</th> -->
                        <th>REJ</th>
                        <th>WIP</th>
                        <th>REJ%</th>
                        <!-- FINISHING -->
                        <th>PCKED</th>
                        <th>PCK PEND</th>
                        <th>SHIPPED</th>
                        <th>SHIP PEND</th>
                        <th>TFR IN</th>
                        <th>TFR OUT</th>
                    </tr>
                    </thead>
                    <tbody>
 
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4" class="sideallign">Total:</th>
                            <th id="totalOrQty" class="sideallign"></th>
                            <th id="totalBomQty" class="sideallign"></th>
                            <th id="totalCutQty" class="sideallign"></th>
                            <th id="totalToBeCut" class="sideallign"></th>
                            <th id="totalLineInput" class="sideallign"></th>
                            <th id="totalCutVsInp" class="sideallign"></th>
                            <th id="totalSewQty" class="sideallign"></th>
                            <th id="totalRejQty" class="sideallign"></th>
                            <th id="totalInpVsOutp" class="sideallign"></th>
                            <th colspan="1" class="sideallign"></th>
                            <th id="totalPckedQty" class="sideallign"></th>
                            <th id="totalAckVsPck" class="sideallign"></th>
                            <th id="totalShippedQty" class="sideallign"></th>
                            <th id="totalPckVsShip" class="sideallign"></th>
                            <th id="totalStockIn" class="sideallign"></th>
                            <th id="totalStockOut" class="sideallign"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> -->
        </div>
    </div>
</div>



<!--BUDGET popup-->
<div class="modal fade" id="tableModalbudget" tabindex="-1" aria-labelledby="tableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal_popup">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tableModalLabelbudget"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <div class="row">

                    <div class="col-md-4">
                        <h6>BUDGET ABSTRACT:</h6>
                        <table id="tableAppstrike" class="table table-bordered table_popup mt-3 mb-3">
                            <thead class="header-fixed">
                                <tr>
                                    <th>S.No</th>
                                    <th>ACCESS TYPE</th>
                                    <th>APPROVED AMOUNT</th>
                                    <th>PENDING AMOUNT</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="2" class="sideallign">Total:</th>
                                    <th id="totalAppQtyStrike" class="sideallign">0</th>
                                    <th id="totalAppAmountStrike" class="sideallign">0</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>


                    <div class="col-md-4">
                        <h6>COMBINE ABSTRACT:</h6>
                        <table id="tableRateAmount" class="table table-bordered table_popup  mt-3 mb-3">
                            <thead class="header-fixed">
                                <tr>
                                    <th>S.No</th>
                                    <th>TYPE</th>
                                    <th>APPROVED AMOUNT</th>
                                    <th>RATE PER PIECE</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2" class="sideallign">Total :</td>
                                    <td id="totalAmount" class="sideallign">0</td>
                                    <td id="totalRate" class="sideallign">0</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <!-- Pie Chart -->

                    <!-- <div class="col-md-4 d-flex justify-content-center align-items-center" style="height: 250px; display: none !important;">
                        <canvas id="pieChart"></canvas>
                    </div> -->

                    <!--bar chart-->
                    <div class="col-md-4 d-flex justify-content-center align-items-center" style="height: 250px;">
                        <canvas id="barChart"></canvas>
                    </div>
                </div>

                <h6>BUDGET DETAILS:</h6>
                <div class="row">
                    <div class="col-md-3 budget_acc">
                        <select id="accessTypeDropdown" class="form-select mb-3">
                            <option value="">All Access Types</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select id="approvestatus" class="form-select mb-3">
                            <option value="">ALL</option>
                            <option value="approved">Approved Amount</option>
                            <option value="pending">Pending Amount</option>
                        </select>
                    </div>
                </div>

                <table id="tableListData" class="table table-bordered table_popup">
                    <thead class="header-fixed">
                        <tr>
                            <!-- <th>S.No</th>
                            <th>ACCESS TYPE</th>
                            <th>PROCESS</th>
                            <th>ITEM</th>
                            <th>COLOR</th>
                            <th>SIZE</th>
                            <th>QTY</th>
                            <th>RATE</th>
                            <th>APPROVED QTY</th>
                            <th>APPROVED RATE</th>
                            <th>APPROVED AMOUNT</th> -->
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot>
                        <tr>
                            <th colspan="10" class="sideallign">Total:</th>
                            {{-- <th id="totalQtyList" class="sideallign"></th> --}}
                            {{-- <th colspan="1" class="sideallign"></th> --}}
                            {{-- <th id="totalAppQtyList" class="sideallign"></th> --}}
                            {{-- <th colspan="1" class="sideallign"></th> --}}
                            <th id="totalAppAmountList" class="sideallign">0</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="imagepopup" tabindex="-1" aria-labelledby="imagepopupLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imagepopupLabel">Style Details <span id="styleorderno"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Image grid will be injected here -->
            </div>
        </div>
    </div>
</div>



@endsection


@section('script')


<script>




$(document).on('click', '.wip-popup', function() {
    
    let ocn = $(this).data('order-no');
    let unit = $(this).data('unit');
   
    $('#tableModalwip').data('order-no', ocn)
                              .data('unit', unit);

   
    $('#tableModalwip').modal('show');
});


$(document).ready(function() {


    
let isAjaxFRCInProgress = false;


$('#tableModalwip').on('shown.bs.modal', function () {
   
    if (isAjaxFRCInProgress) {
        console.log('An AJAX request is already in progress.');
        return; 
    }

   
    isAjaxFRCInProgress = true;

    console.log($(this).data('order-no'));
    let ocnno = $(this).data('order-no');
    let unit = $(this).data('unit');
    
    $.ajax({
        url: '{{ route('wipdetails') }}',  
        method: 'GET',
        data: {
            ocnno: ocnno,
            unit: unit
        },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
        },
        dataType: 'json',
        beforeSend: function () {
            $("#preloder").fadeIn();
                },
        success: function (response) {
           
            FRCTable(response.data);
        },
        error: function (xhr, status, error) {
            console.error('Error fetching data:', error);
        },
        complete: function () {
            $("#preloder").fadeOut();
            isAjaxFRCInProgress = false;
        }
    });

    

});













    $(document).on('click', 'button[data-bs-target="#buttonpopup"]', function() {
        var masterId = $(this).data('master-id');
        var remarks = $(this).data('remarks');



        $('#remarkcon').val(remarks);

        $('#master_id').val(masterId);
    });
    $('#ocrForm').on('submit', function(e) {

        e.preventDefault(); // Prevent default form submission

        // Capture form data
        var formData = $(this).serialize(); // Serialize form data for URL encoding

        // Send form data via AJAX
        $.ajax({
            url: '{{ env("API_URL") }}alertinfo_store', // Concatenate the API URL
            method: 'POST',
            data: formData, // Send serialized form data
            success: function(data) {
                if (data.success) {
                    // If the submission is successful, redirect
                    window.location.href = '{{ env("API_URL") }}merchandiserorder';
                } else {
                    // Handle errors if necessary
                    alert('Error: ' + data.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });
});



</script>

<script>
  $(document).ready(function() {
    // Function to load and display alert data
    function loadAlertData(alertid) {
        $('#notifyocn').text(alertid);
        var orderNo = alertid.replace(/\\/g, '-');
        $.ajax({
            url: "{{ route('alertinfo') }}",
    type: "GET",
    data:{
        orderNo:orderNo
        },
    success: function(response) {
        if(response.success && response.data.length > 0) {
            var tableRows = ''; // Initialize a variable to hold all table rows
            var index = 1;
            
            // Iterate over each item in the response data array
            response.data.forEach(function(alertData, index) {
                
                const alertdate = alertData.Alert_Date.split(' ')[0];
                const targetdate = alertData.Target_Date.split(' ')[0];
                    // console.log(alertdate);
 
 
                const formattedAlertDate = alertdate.split('-').reverse().join('-');
                const formattedTargetDate = targetdate.split('-').reverse().join('-');
                tableRows += `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${alertData.Mode}</td>
                        <td>${formattedTargetDate}</td>
                         <td>${formattedAlertDate}</td>
                    
                    </tr>
                `;
            });

            // Append all rows to the table body
            $('#tableModalnotification tbody').html(tableRows);
        }
    },
    error: function(xhr, status, error) {
        console.error("Failed to fetch alert data: ", error);
    }
});

    }

    // Trigger the alert data load when the modal is about to be shown
    $('#tableModalnotification').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget); 
        var alertid = button.data('order-no');
        loadAlertData(alertid);
    });

    // Close #tableModalnotification when #buttonpopup is shown
    $('#buttonpopup').on('show.bs.modal', function () {
        $('#tableModalnotification').modal('hide');
    });
});

$(document).on('click', '.ocr-status-trigger', function() {
    var orderNo = $(this).data('order-no');
    $('#tableModalLabell').text('OCR Status - Order No: ' + orderNo);
});

</script>

<script src = 'chennai-team/wipdetails.js'></script>


<script>



    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#shipment_date", {
            dateFormat: "d-m-Y",
            mode: "range",
        });
    });

    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#order_date", {
            dateFormat: "d-m-Y",
            mode: "range",
        });
    });

    document.addEventListener("DOMContentLoaded", function() {
        // Initialize Flatpickr
        flatpickr("#kit_date", {
            dateFormat: "d-m-Y",
            mode: "range",
        });
    });
</script>


<script>
    $.fn.dataTable.ext.type.order['date-dd-mm-yyyy-pre'] = function(d) {
        if (d === null || d === "") {
            return Infinity;  // Treat empty dates as the largest value
        }
        return moment(d, 'DD-MM-YYYY').isValid() ? moment(d, 'DD-MM-YYYY').format('YYYYMMDD') : Infinity;
    };
    $(document).ready(function() {

//         var ctx = document.getElementById('pieChart').getContext('2d');
// var pieChart = new Chart(ctx, {
//     type: 'pie',
//     data: {
//         labels: ['Bom', 'Cloth', 'Production'],
//         datasets: [{
//             label: 'Approved Amounts',
//             data: [30, 50, 20], // Replace with actual data
//             backgroundColor: ['#FF6384', '#36A2EB', '#FFCE56'], // Replace with actual colors
//         }]
//     },
//     options: {
//         responsive: true,
//         plugins: {
//             legend: {
//                 position: 'bottom', // You can use 'top', 'bottom', 'left', or 'right'
//             },
//             datalabels: {
//                 color: '#ffffff', // Color of the text inside the pie chart
//                 formatter: (value, ctx) => {
//                     let sum = ctx.dataset.data.reduce((a, b) => a + b, 0);
//                     let percentage = (value * 100 / sum).toFixed(2) + "%";
//                     return percentage;
//                 },
//                 font: {
//                     weight: 'bold',
//                     size: 14
//                 }
//             }
//         }
//     },
//     plugins: [ChartDataLabels] // Include the Data Labels plugin
// });

    // Initialize DataTable once
    var table = $('#operationlist').DataTable({
            paging: false,
            searching: true,
            ordering: true,
            order: [[0, 'asc']],  
            columnDefs: [
                {
                    targets: [5,7], 
                    type: 'date-dd-mm-yyyy'  
                },
                { orderable: false, targets: [2, 3] } 
            ],
            dom: 'Bfrtip',  
            buttons: [
            {
                extend: 'excelHtml5',
                text: 'Excel',
                autoFilter: true,
                titleAttr: 'Excel',

                exportOptions: {
                    format: {
                        body: function(data, row, column, node) {
                            // Use moment.js to convert dd-mm-yyyy to ISO date format yyyy-mm-dd for Excel


                            if ((column === 5 || column === 7 ) && /\d{2}-\d{2}-\d{2}/.test(data)) {
                                // Convert date to 'dd/mm/yyyy'
                                return moment(data, 'DD-MM-YY').format('YYYY-MM-DD');
                            } else {
                                // For other columns, return the data without changes
                                return $('<div>').html(data).text(); // Strips any HTML tags if present
                            }
                        }
                    }
                }

            },

            {
                extend: 'pdfHtml5',
                text: 'PDF',
                titleAttr: 'PDF',
                orientation: 'landscape',
                pageSize: 'A3',
                exportOptions: {
                    columns: ':visible'
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 7; // Reduce the font size
                    doc.content[1].table.widths = 'auto'; // Set column width to auto
                    doc.content[1].table.dontBreakRows = true; // Ensure content continues on the next page if too large
                }
            }
        ],
                footerCallback: function (row, data, start, end, display) {
                    var api = this.api();
                    
                    let intVal = function (i) {
                        return typeof i === 'string'
                            ? i.replace(/[\$,]/g, '') * 1
                            : typeof i === 'number'
                            ? i
                            : 0;
                    };

                    

                    var totalOrdQty = api.column(3, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                                       
                    var totalShipQty = api.column(4, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                    var totalBalToIssQty = api.column(9, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                    var totalBomQty = api.column(10, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0); 
                    var totalSMstockQty = api.column(11, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                    var totalN2Qty = api.column(12, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (parseInt(b) || 0);
                    }, 0);
                    var totalN1Qty = api.column(13, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);


                    var totalOverAllQty =  api.column(14, { page: 'current' }).data().reduce(function (sum, value) {
            // Remove any HTML tags and convert to float
            var numericValue = parseFloat(value.replace(/<[^>]*>/g, '').trim()) || 0;
            return sum + numericValue;
        }, 0);

                    

                    
                    var totalInputQty = api.column(15, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                    var totalOutputQty = api.column(16, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);
                    var totalWIPQty = api.column(17, { search: 'applied' }).data().reduce(function(a, b) {
                        return (intVal(a) || 0) + (intVal(b) || 0);
                    }, 0);   

                    // Helper function to convert to lakhs
                    var convertToLakhs = function (value) {
                        return value / 100000;
                    };

                    $('#totalOrdQty').html(convertToLakhs(totalOrdQty).toFixed(2));
                    $('#totalBomQty').html(convertToLakhs(totalBomQty).toFixed(2));
                    $('#totalShipQty').html(convertToLakhs(totalShipQty).toFixed(2));
                    $('#totalBalToIssQty').html(convertToLakhs(totalBalToIssQty).toFixed(2));
                    $('#totalSMstockQty').html(convertToLakhs(totalSMstockQty).toFixed(2));
                    $('#totalN2Qty').html(convertToLakhs(totalN2Qty).toFixed(2));
                    $('#totalN1Qty').html(convertToLakhs(totalN1Qty).toFixed(2));
                    $('#totalOverAllQty').html(convertToLakhs(totalOverAllQty).toFixed(2));
                    $('#totalInputQty').html(convertToLakhs(totalInputQty).toFixed(2));
                    $('#totalOutputQty').html(convertToLakhs(totalOutputQty).toFixed(2));
                    $('#totalWIPQty').html(convertToLakhs(totalWIPQty).toFixed(2));

                }
        });

    // Load data on page load
    loadData();

    

    // Event listener for checkbox click
    $('#operationlist tbody').on('click', '.row-remcheck', function () {
        let row = $(this).closest('tr');

        // Check if the checkbox is checked
        if (this.checked) {
            // Add fade-out animation class
            row.addClass('fade-out');

            // Wait for animation to complete before removing row
            setTimeout(function () {
                // Remove the row from the DataTable
                table.row(row).remove().draw(false);
            }, 500); // Matches the animation duration
        }
        /*if (confirm('Are you sure you want to delete this row?')) {
            var row = $(this).closest('tr');
            table.row(row).remove().draw(false);
        } else {
            $(this).prop('checked', false);
        }*/
    });





    $('#filterForm').on('submit', function(e) {
        $("#preloder").fadeIn();
        e.preventDefault();
        loadData();     
    });

    $('#resetButton').on('click', function() {
        // Reset the form fields
        $('#filterForm')[0].reset();
        $("#preloder").fadeIn();
        // Clear dynamically populated dropdowns
        $('#unit_name').empty().append('<option value="">Select Unit Name</option>');
        $('#buyer_ocn').empty().append('<option value="">--Select Buyer Ocn NO--</option>');
        $('#ocn_no').empty().append('<option value="">--Select OCN NO--</option>');
        $('#status_op').empty().append('<option value="">--Select Status--</option>');
        // Reload data with default values
        loadData();
    });

 

    // Function to load data based on filters
    function loadData() {
        var unit_name = $('#unit_name').val();
       
        var buyer_ocn = $('#buyer_ocn').val();
        //buyer_ocn=buyer_ocn.split('&').join('---');
        var ocn_no = $('#ocn_no').val();
        var status_op = $('#status_op').val();
        $.ajax({
            url: "{{ route('operationlist') }}",
            type: "GET",
            data: $('#filterForm').serialize(),

            success: function(data) {
                successData(data);
            }
        });
    }

    function successData(data){
        
        var unit_name = $('#unit_name').val();       
        var buyer_ocn = $('#buyer_ocn').val();
        var ocn_no = $('#ocn_no').val();
        var status_op = $('#status_op').val();
        
        $("#preloder").fadeOut();

        var table = $('#operationlist').DataTable();
        table.clear().draw();// Clear the existing data
        var unitnamearr = [];
        var buyerocnarr = [];
        var ocnarr = [];
        var statusarr = [];
        const valuesArray = Object.values(data.data.listdata);

        let newCount = 1;
        $.each(valuesArray, function(index, row) {           

                const  ckdate = new Date(row.Ck_Date);
                const  shipdate = new Date();                    
                const dateStr1 = ckdate;
                const dateStr2 = shipdate;
                var color = '';
                let rowClass = '';
                //console.log(row.Ck_Date + 'check');
                if (ckdate !== '') {
                    const date1 = ckdate; // Convert 'Ck_Date' to Date object

                    // Compare if current date (shipdate) is greater than 'ckdate'
                    if (shipdate > date1 &&  row.File_Status == 'Pending' ) {
                        //console.log(date1);
                        var color = 'red';
                    } else {
                        //console.log(date1);
                        var color = '';
                    }
                }
                
                var parts =  row.Buyer_Ocn.split('-');

                if (row.Sno == 1) {                        
                        rowClass = 'highlight-next';
                        var rowInlineStyle = 'background-color: #ADD8E6;';                        
                }
                function removeSpaces(string) {
                    return string.replace(/\s+/g, ''); // Removes all whitespace characters
                }
                var datastyle = row.Style.substring(0,10);
            
                var style_dis = removeSpaces(datastyle.charAt(0).toUpperCase() + datastyle.slice(1).toLowerCase());
                var File_Rcvd = formatDateCk(row.File_Rcvd);
                var Ck_Date = formatDateCk(row.Ck_Date);
                var Ck_Actual='';
                if(row.CK_Actual!=''){
                Ck_Actual = formatDateCk(row.CK_Actual); 
                }
                var Lead_Days = row.Lead_Days;
                
                var newRow = table.row.add([
                '<input type="checkbox" class="form-check-input row-remcheck"> '+row.Unit_Name, 
                                    
                '<span class="buyer-popup" title="'+row.Order_No+'" style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-order-no="' + row.Order_No + '" data-bs-target="#tableModalbuyer" data-style="' + row.style + '">' +  row.Buyer_Ocn.toLowerCase()+ '</span>',
                '<span class="style-popup" title="'+row.Style+'" style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-order-no="' + row.Order_No + '" data-bs-target="#imagepopup" data-style="' + row.style + '">' + style_dis + '</span>',
                formatIndianNumber1(row.Ord_Qty),
            
                formatIndianNumber1(row.Shp_Qty),
            
                formatDateCk(row.Ck_Date), 
            
                '<span data-bs-target="#tableModalFileStatus" class="filestatus" data-order-no="GIL\\OCN'+parts[1]+'" style="cursor: pointer; color: ' +
                color
                + ';" data-bs-toggle="modal" data-bs-target="#" title = "File Received : '+File_Rcvd+', Close Dt : '+Ck_Actual+',  Lead days : '+Lead_Days+' ">' +
                row.File_Status +
                '</span>','<span data-sort="'+formatDateCk(row.Ship_Date)+'" style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-bs-target="#tableModalBuyerpo" data-order-no="GIL\\OCN'+parts[1]+'" class="buyerpoview" title="Buyer PO">'+formatDateCk(row.Ship_Date)+
                '</span>',
            
                '<span style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-bs-target="#tableModalpo" data-order-no="GIL\\OCN'+parts[1]+'" class="poview" title="Supplier PO"> View </span>',
                formatIndianNumber1(row.Bal_To_Iss),
                formatIndianNumber1(row.Ack_Pend),         
            
            
                row.SM_Stk,
                row.N_2,

                row.N_1,
            
            
                '<span style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-order-no="GIL\\OCN'+parts[1]+'" class="production" data-bs-target="#tableModalproduction" title="Overall Output"> '+row.Overall_Output+' </span>',
                
                row.Unit_Input,
                row.Unit_Output,
            
                '<span class="wip-popup" title="'+row.Order_No+'" style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-order-no="' + row.Order_No + '" data-bs-target="#tableModalwip" data-unit="' + row.Unit_Name + '">' +  row.Unit_WIP+ '</span>',
                row.Status,
            
            ]).draw(false);  // Add new row and redraw table
            newCount++;

            if (rowClass) {
                $(newRow.node()).addClass(rowClass);
                
            }

            if (row.Unit_Name) {
                unitnamearr.push(row.Unit_Name);
            }
            if (row.Buyer) {
                buyerocnarr.push(row.Buyer);
            }
        
            if (row.Status) {
                statusarr.push(row.Status);
            }
            if (row.Order_No) {
                ocnarr.push(row.Order_No);
            }// Collect unique buyers and OCN numbers for dropdowns
        
        });

        if (unit_name == '') {
        
            $('#unit_name').empty().append('<option value="">Select Unit Name</option>');
            $.each([...new Set(unitnamearr)], function(index, value) {
                $('#unit_name').append('<option value="' + value + '">' + value + '</option>');
            });
        } else {
            $('#unit_name option[value="' + unit_name.replace(/"/g, '\\"') + '"]').prop('selected', true);
        }
        if (buyer_ocn == '') {
        
            $('#buyer_ocn').empty().append('<option value="">Select Buyer Ocn</option>');
            $.each([...new Set(buyerocnarr)], function(index, value) {
                $('#buyer_ocn').append('<option value="' + value.split('&').join('---') + '">' + value + '</option>');
            });
        } else {
            $('#buyer_ocn option[value="' + buyer_ocn.replace(/"/g, '\\"') + '"]').prop('selected', true);
        }

        if (status_op == '') {
        
        $('#status_op').empty().append('<option value="">Select Status</option>');
        $.each([...new Set(statusarr)], function(index, value) {
            $('#status_op').append('<option value="' + value + '">' + value + '</option>');
        });
        $('#status_op').append('<option value="Completed">Completed</option>');

        } else {
        $('#status_op option[value="' + status_op.replace(/"/g, '\\"') + '"]').prop('selected', true);
        }
        if (ocn_no == '') {
        
        $('#ocn_no').empty().append('<option value="">Select Ocn</option>');
        $.each([...new Set(ocnarr)], function(index, value) {
            $('#ocn_no').append('<option value="' + value + '">' + value + '</option>');
        });
        } else {
        $('#ocn_no option[value="' + ocn_no.replace(/"/g, '\\"') + '"]').prop('selected', true);
        }

    }

    // Load OCN options based on selected buyer and order status
    $('#buyer_name, #order_status,#file_status').on('change', function() {
        var buyerName = $('#buyer_name').val();
        var orderStatus = $('#order_status').val();
        var file_Status = $('#file_status').val();


        if (buyerName || orderStatus || file_Status) {
            $.ajax({
                url: "{{ route('getOcnByBuyer') }}",
                type: "GET",
                data: {
                    buyer_name: buyerName,
                    order_status: orderStatus,
                    file_status:file_Status
                },
                success: function(data) {
                    $('#ocn_no').empty().append('<option value="">--Select OCN NO--</option>');
                    $.each(data, function(key, value) {
                        $('#ocn_no').append('<option value="' + value + '">' + value + '</option>');
                    });
                }
            });
        } else {
            $('#ocn_no').empty().append('<option value="">--Select OCN NO--</option>');
        }
    });
    });

</script>
<script>
$(document).ready(function() {


        $(document).on('click', '.style-popup', function() {


                var orderNo = $(this).attr('data-order-no');

                $('#styleorderno').text(orderNo);
                orderNo = orderNo.replace(/\\/g, '-');

                const apiUrl = `{{ route('merchlayout') }}`;

                $.ajax({
                url: apiUrl,
                method: 'GET',
                data:{orderNo : orderNo},
                contentType: 'application/json',
                success: function (response) {
                    //console.log(response);

                    if (response.success && response.data.length > 0) {
                        var images = [];
                        var file = [];
                        var docnamee = [];

                        response.data.map(function(item) {
                            var extension = item.docname.split('.').pop().toLowerCase();
                            if (['png', 'jpg', 'jpeg'].includes(extension)) {
                                images.push(`{{asset('frontend/buyimgpath/${item.docname}')}}`);
                                file.push(`frontend/buyimgpath/${item.docname}`);
                                docnamee.push(`${item.doctitle}`);
                            } else if (extension === 'pdf') {
                                images.push(`{{asset('LifeAtGainup_Assets/assets/images/pdf.png')}}`);
                                file.push(`frontend/BuyDocPath/${item.docname}`);
                                docnamee.push(`${item.doctitle}`);
                            } else if (['xlsx', 'xls'].includes(extension)) {
                                images.push(`{{asset('LifeAtGainup_Assets/assets/images/excel.png')}}`);
                                file.push(`frontend/BuyDocPath/${item.docname}`);
                                docnamee.push(`${item.doctitle}`);
                            }
                        });

                        // Set up the gallery
                        setupGallery(images, file, docnamee);
                    } else {
                        // Display message when no data is available
                        $('#imagepopup .modal-body').html('<p style="text-align: center; font-size: 16px;">No data available</p>');
                        $('#imagepopup').modal('show');
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                }
                });

                function setupGallery(images, file, docnamee) {
                // Image gallery structure with grid
                var galleryHtml = `
                    <div class="popup-gallery row">
                        ${images.map((img, index) => `
                            <div class="col-md-3 col-sm-4 col-6 image-container" style="text-align: center; margin-bottom: 15px;">
                                <a target="_blank" href="${file[index]}" title="Image ${index + 1}">
                                    <img src="${img}" style="width: 100px; height: 100px; object-fit: cover;" alt="Image ${index + 1}">
                                </a>
                                <label style="display: block; margin-top: 5px;">${docnamee[index]}</label>
                            </div>
                        `).join('')}
                    </div>
                `;

                // Inject the gallery content into the modal body
                $('#imagepopup .modal-body').html(galleryHtml);
                $('#imagepopup').modal('show');

                // Close Magnific Popup when custom button is clicked
                $(document).on('click', '.mfp-custom-close', function() {
                    $.magnificPopup.close();
                });
                }
        });

});
</script>






<!--Budget popup-->
<script>
    $(document).ready(function () {
        let appstrikeTable = null;
        let listDataTable = null;
        let rateAmountTable = null;
        let barChart = null;

        $(document).on('click', '.budget_status', function () {
            $("#preloder").fadeIn();
            let orderNo = $(this).data('order-no');
            let orderQty = $(this).data('order-qty');
            let budgetvalue = $(this).data('bud-value');
            // $('#tableModalLabelbudget').text(`BUDGET STATUS - ${orderNo} (Order Qty: ${orderQty}) Sale Price: ${saleprice}`);
            $('#tableModalLabelbudget').html(`BUDGET STATUS - ${orderNo} (Order Qty: ${orderQty}) <span style="color: blue;">Booked Price: ${budgetvalue}</span>`);


            orderNo = orderNo.replace(/\\/g, '-');
            const apiUrl = `{{ route('budgetstatus') }}`;
            //console.log(apiUrl);
            
            $.ajax({
                url: apiUrl,
                method: 'GET',
                data:{orderNo:orderNo},
                headers: {
            
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            
            },
                
                success: function (response) {
                    $("#preloder").fadeOut();
                    //console.log(response)
                    if (response.success) {
                        populateAppstrikeTable(response.data.appstrike);
                        populateListDataTable(response.data.listdata, orderNo);
                        populateRateAmountTable(response.data.mdappstrike);
                        generateBarChart(response.data.mdappstrike);

                    } else {
                        console.error('Error fetching data:', data.message);
                    }
                },
                error: function (xhr, status, error) {
                   // console.log (error)  ;
                    console.error('Error:', error);
                }
            });
        });

        $('#tableModalbudget').on('hidden.bs.modal', function () {
            if (appstrikeTable) {
                appstrikeTable.destroy();
                appstrikeTable = null;
            }
            if (listDataTable) {
                listDataTable.destroy();
                listDataTable = null;
            }
            if (rateAmountTable) {
                rateAmountTable.destroy();
                rateAmountTable = null;
            }
            $('#tableAppstrike tbody, #tableListData tbody, #tableRateAmount tbody').empty();
            if (barChart) {
                    barChart.destroy();
                }
        });

        function populateRateAmountTable(data) {
        const $tableBody = $('#tableRateAmount tbody');
        let totalApp_Amnt = 0;
        let totalRate_Per_Piece = 0;

        $tableBody.empty();

        $.each(data, function (index, item) {
            const row = `
                <tr>
                    <td>${index + 1}</td>
                    <td>${item.Type}</td>
                    <td class="sideallign">${parseFloat(item.App_Amnt).toFixed(2)}</td>
                    <td class="sideallign">${parseFloat(item.Rate_Per_Piece).toFixed(2)}</td>
                </tr>
            `;
            $tableBody.append(row);

            totalApp_Amnt += parseFloat(item.App_Amnt) || 0;
            totalRate_Per_Piece += parseFloat(item.Rate_Per_Piece) || 0;
        });

        $('#totalAmount').text(totalApp_Amnt.toFixed(2));
        $('#totalRate').text(totalRate_Per_Piece.toFixed(2));
    }


    function generateBarChart(data) {
    const labels = data.map(item => item.Type);
    const appAmountData = data.map(item => parseFloat(item.App_Amnt).toFixed(2));
    const rateData = data.map(item => parseFloat(item.Rate_Per_Piece).toFixed(2));

    const ctx = document.getElementById('barChart').getContext('2d');

    // Destroy previous chart instance if it exists
    if (barChart) {
        barChart.destroy();
    }

    // Create new bar chart
    barChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Approved Amount',
                data: appAmountData, // App Amount will be the height of the bar
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(tooltipItem) {
                            const appAmount = tooltipItem.raw; // App Amount from the bar
                            const ratePerPiece = rateData[tooltipItem.dataIndex]; // Rate per Piece from the dataset
                            return `App Amount: ${appAmount}, Rate per Piece: ${ratePerPiece}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    }



        function populateAppstrikeTable(data) {
            const $tableBody = $('#tableAppstrike tbody');
            const $accessTypeDropdown = $('#accessTypeDropdown');
            const accessTypes = new Set();

            $tableBody.empty();
            let totalAppAmount = 0;
            let totalUnAppAmount = 0;

            $.each(data, function (index, item) {
                let appAmount = item.App_Amount;
                let unappAmount = item.Pend_Amount;
                const row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.Access_Type}</td>
                       <td class="sideallign">${parseFloat(appAmount).toFixed(2)}</td>
                        <td class="sideallign">${parseFloat(unappAmount).toFixed(2)}</td>
                    </tr>
                `;
                $tableBody.append(row);

                totalAppAmount += parseFloat(appAmount) || 0;
                totalUnAppAmount += parseFloat(unappAmount) || 0;

                accessTypes.add(item.Access_Type);
            });

            $('#totalAppQtyStrike').text(totalAppAmount.toFixed(2));
            $('#totalAppAmountStrike').text(totalUnAppAmount.toFixed(2));

            $accessTypeDropdown.empty();
            $accessTypeDropdown.append('<option value="">All Access Types</option>');
            accessTypes.forEach(function (accessType) {
                $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
            });

            if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
                appstrikeTable = $('#tableAppstrike').DataTable({
                    paging: false,
                    searching: false,
                    ordering: false,
                    info: false,
                    drawCallback: function () {
                        let totalFilteredAppQty = 0;
                        let totalFilteredAppAmount = 0;

                        $('#tableAppstrike tbody tr:visible').each(function () {
                            const appQty = parseFloat($(this).find('td:nth-child(3)').text()) || 0;
                            const appAmount = parseFloat($(this).find('td:nth-child(4)').text()) || 0;

                            totalFilteredAppQty += appQty;
                            totalFilteredAppAmount += appAmount;
                        });

                        $('#totalAppQtyStrike').text(totalFilteredAppQty.toFixed(2));
                        $('#totalAppAmountStrike').text(totalFilteredAppAmount.toFixed(2));
                    }
                });
            }
        }

        function populateListDataTable(data, orderNo) {
        const $tableBody = $('#tableListData tbody');
        const $thead = $('#tableListData thead tr');
        const $tfoot = $('#tableListData tfoot tr');

        // Clear existing DataTable instance if any
        if ($.fn.DataTable.isDataTable('#tableListData')) {
            $('#tableListData').DataTable().clear().destroy();
        }

        // Clear table content
        $tableBody.empty();
        $thead.empty();
        $tfoot.empty();

        let showApprovedAmount = false;
        let showPendingAmount = false;

        $.each(data, function (index, item) {
            if (item.App_Status === 'Approved') {
                showApprovedAmount = true;
            }
            if (item.App_Status === 'Pending') {
                showPendingAmount = true;
            }
        });

        // Build table headers
        let headerHTML = `
            <th>S.No</th>
            <th>ACCESS TYPE</th>
            <th>PROCESS</th>
            <th>ITEM</th>
            <th>COLOR</th>
            <th>SIZE</th>
            <th>QTY</th>
            <th>RATE</th>
            <th>APPROVED QTY</th>
            <th>APPROVED RATE</th>
        `;
        if (showApprovedAmount) {
            headerHTML += '<th>APPROVED AMOUNT</th>';
        }
        if (showPendingAmount) {
            headerHTML += '<th>PENDING AMOUNT</th>';
        }
        $thead.append(headerHTML);

        // Build table footers
        let footerHTML = `
            <th colspan="10" class="sideallign">Total:</th>
        `;
        if (showApprovedAmount) {
            footerHTML += '<th id="totalAppAmountList" class="sideallign">0</th>';
        }
        if (showPendingAmount) {
            footerHTML += '<th id="totalPendAmountList" class="sideallign">0</th>';
        }
        $tfoot.append(footerHTML);

        let totalAppAmount = 0;
        let totalPendAmount = 0;

        $.each(data, function (index, item) {
            const row = `
                <tr>
                    <td>${index + 1}</td>
                    <td>${item.Access_Type}</td>
                    <td>${item.Process}</td>
                    <td>${item.Item}</td>
                    <td>${item.Color}</td>
                    <td>${item.Size}</td>
                    <td class="sideallign">${parseFloat(item.Quantity).toFixed(2)}</td>
                    <td class="sideallign">${parseFloat(item.Rate).toFixed(2)}</td>
                    <td class="sideallign">${parseFloat(item.App_Qty).toFixed(2)}</td>
                    <td class="sideallign">${parseFloat(item.App_Rate).toFixed(2)}</td>
                    ${showApprovedAmount ? `<td class="sideallign">${parseFloat(item.App_Amount).toFixed(2)}</td>` : ''}
                    ${showPendingAmount ? `<td class="sideallign">${parseFloat(item.Pend_Amount).toFixed(2)}</td>` : ''}
                </tr>
            `;
            $tableBody.append(row);

            if (showApprovedAmount) {
                totalAppAmount += parseFloat(item.App_Amount) || 0;
            }
            if (showPendingAmount) {
                totalPendAmount += parseFloat(item.Pend_Amount) || 0;
            }
        });

        // Update footer with total amounts
        if (showApprovedAmount) {
            $('#totalAppAmountList').text(totalAppAmount.toFixed(2));
        }
        if (showPendingAmount) {
            $('#totalPendAmountList').text(totalPendAmount.toFixed(2));
        }

        // Initialize DataTable
        $('#tableListData').DataTable({
            paging: false,
            searching: true,
            ordering: true,
            dom: 'Bfrtip',
            buttons: [
                { 
                    extend: 'excelHtml5', title: 'List Data - ' + orderNo, footer: true
                },
                { 
                    extend: 'pdfHtml5', title: 'List Data - ' + orderNo, orientation: 'landscape', pageSize: 'A4', footer: true
                }
            ],
            drawCallback: function () {
                let totalFilteredAppAmount = 0;
                let totalFilteredPendAmount = 0;

                $('#tableListData tbody tr:visible').each(function () {
                    const appAmount = showApprovedAmount ? parseFloat($(this).find('td:nth-child(11)').text()) || 0 : 0;
                    const pendAmount = showPendingAmount ? parseFloat($(this).find('td:nth-child(12)').text()) || 0 : 0;

                    totalFilteredAppAmount += appAmount;
                    totalFilteredPendAmount += pendAmount;
                });

                if (showApprovedAmount) {
                    $('#totalAppAmountList').text(totalFilteredAppAmount.toFixed(2));
                }
                if (showPendingAmount) {
                    $('#totalPendAmountList').text(totalFilteredPendAmount.toFixed(2));
                }
            }
        });

        // Access Type filter
        $('#accessTypeDropdown').on('change', function () {
            const selectedAccessType = $(this).val();
            $('#tableListData').DataTable().column(1).search(selectedAccessType).draw(); 
        });

        // Amount filter
        $('#approvestatus').on('change', function () {
            const selectedStatus = $(this).val();

            $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
                const appAmount = showApprovedAmount ? parseFloat(data[10]) || 0 : 0;
                const pendAmount = showPendingAmount ? parseFloat(data[11]) || 0 : 0;

                if (selectedStatus === 'approved' && appAmount > 0) {
                    return true;
                } else if (selectedStatus === 'pending' && pendAmount > 0) {
                    return true;
                } else if (selectedStatus === '') {
                    return true;
                }
                return false;
            });

            $('#tableListData').DataTable().draw();
            $.fn.dataTable.ext.search.pop();
        });
    }
    });

</script>





<!--production popup-->
<script>
    $(document).ready(function () {
        let productionTable = null;
        let abstractTable = null;

        $(document).on('click', '.production', function () {
            $("#preloder").fadeIn();
            let orderNo = $(this).data('order-no');
            $('#tableModalLabelproduction').text('PRODUCTION STATUS - ' + orderNo);
            $('#noteText').text('Note: All columns represent quantities.');
            orderNo = orderNo.replace(/\\/g, '-');

            const sizeurl = `{{ route('sizebreakup') }}`;
            const abstracturl = `{{ route('productstatus') }}`;   
            
           // console.log('sizeurl', sizeurl);
            //console.log('abstracturl', abstracturl);
            
            // Fetch Size Breakup Data
            $.ajax({
                url: sizeurl,
                method: 'GET',
                data:{orderNo:orderNo},
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function (response) {
                    $("#preloder").fadeOut();
                    //console.log('Size Breakup Response:', response);
                    if (response.success) {
                        populateDetailsTable(response.data, orderNo);
                    } else {
                        console.error('Error fetching details data:', response.message);
                    }
                },
                error: function (xhr, status, error) {
                    $("#preloder").fadeOut();
                    console.error('Error fetching details data:', error);
                }
            });

            // Fetch Production Abstract Data
            $.ajax({
                url: abstracturl,
                method: 'GET',
                data:{orderNo:orderNo},
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function (response) {
                    // $("#preloder").fadeOut();
                   // console.log('Production Abstract Response:', response);
                    if (response.success) {
                        populateAbstractTable(response.data, orderNo);
                    } else {
                        console.error('Error fetching abstract data:', response.message);
                    }
                },
                error: function (xhr, status, error) {
                    $("#preloder").fadeOut();
                    console.error('Error fetching abstract data:', error);
                }
            });
        });

        let ProcessItemTable = null;
        let FileStatusabstractTable = null;

        $(document).on('click', '.filestatus', function () {
            $("#preloder").fadeIn();
            let orderNo = $(this).data('order-no');
            $('#tableModalLabelFileStatus').text('Process PO Details - ' + orderNo);
            //$('#noteText').text('Note: All columns represent quantities.');
            orderNo = orderNo.replace(/\\/g, '-');

            const PoDetailurl = `{{ route('Process_Po_Detail_Proc') }}`;
            const abstracturlFile = `{{ route('Process_Po_Summary_Proc') }}`;   
            
            // Fetch Size Breakup Data
            $.ajax({
                url: PoDetailurl,
                method: 'GET',
                data:{orderNo:orderNo},
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function (response) {
                    $("#preloder").fadeOut();
                    if (response.success) {
                        POItemDetailsTable(response.data, orderNo);
                    } else {
                        console.error('Error fetching details data:', response.message);
                    }
                },
                error: function (xhr, status, error) {
                    $("#preloder").fadeOut();
                    console.error('Error fetching details data:', error);
                }
            });

            // Fetch Production Abstract Data
            $.ajax({
                url: abstracturlFile,
                method: 'GET',
                data:{orderNo:orderNo},
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function (response) {
                    // $("#preloder").fadeOut();
                    if (response.success) {
                        populateAbstractTableFile(response.data, orderNo);
                    } else {
                        console.error('Error fetching abstract data:', response.message);
                    }
                },
                error: function (xhr, status, error) {
                    $("#preloder").fadeOut();
                    console.error('Error fetching abstract data:', error);
                }
            });
        });

        $('#tableModalFileStatus').on('hidden.bs.modal', function () {
            if (ProcessItemTable) {
                ProcessItemTable.destroy();
                ProcessItemTable = null;
            }
            if (FileStatusabstractTable) {
                FileStatusabstractTable.destroy();
                FileStatusabstractTable = null;
            }
            $('#ProcessItemdetailsTable tbody').empty();
            $('#FileStatusabstractTable tbody').empty();
        });

        $('#tableModalproduction').on('hidden.bs.modal', function () {
            if (productionTable) {
                productionTable.destroy();
                productionTable = null;
            }
            if (abstractTable) {
                abstractTable.destroy();
                abstractTable = null;
            }
            $('#detailsTable tbody').empty();
            $('#abstractTable tbody').empty();
        });

        function POItemDetailsTable(data, orderNo) {
            const $tableBody = $('#ProcessItemdetailsTable  tbody');
            const $SupDropdown = $('#SupDropdownPO');
            const $ProDropdown = $('#ProDropdownPO');
            const $colorDropdown = $('#colorDropdownPO');
            const $itemDropdown = $('#itemDropdownPO');
            const $sizeDropdown = $('#sizeDropdownPO');
            $tableBody.empty();
            let Supplier = [];
            let ProcessPO = [];
            let Colors = [];
            let Item = [];
            let Size = [];

            $.each(data, function (index, item) {
                Supplier.push(item.Supplier);
                ProcessPO.push(item.Process);
                Colors.push(item.Color);
                Item.push(item.Item);
                Size.push(item.Size);
                const row = `
                    <tr>
                        <td>${item.Supplier}</td>
                        <td>${item.Process}</td>
                        <td>${item.Item}</td>
                        <td>${item.Color}</td>
                        <td>${item.Size}</td>                        
                        <td class="sideallign">${parseFloat(item.Po_Qty).toFixed(2) || 0}</td>
                        <td class="sideallign">${parseFloat(item.Grn_Qty).toFixed(2) || 0}</td>
                        <td class="sideallign">${parseFloat(item.Bal_Qty).toFixed(2) || 0}</td>
                        <td class="sideallign">${item.Pend_In_Perc}</td>
                    </tr>
                `;
                $tableBody.append(row);
            });

            Supplier = [...new Set(Supplier)];
            $SupDropdown.empty();
            $SupDropdown.append('<option value="">All Supplier</option>');
            Supplier.forEach(function (supplier) {
                $SupDropdown.append(`<option value="${supplier}">${supplier}</option>`);
            });

            ProcessPO = [...new Set(ProcessPO)];
            $ProDropdown.empty();
            $ProDropdown.append('<option value="">All Process</option>');
            ProcessPO.forEach(function (processpo) {
                $ProDropdown.append(`<option value="${processpo}">${processpo}</option>`);
            });
            
            
            Colors = [...new Set(Colors)];
            $colorDropdown.empty();
            $colorDropdown.append('<option value="">All Color</option>');
            Colors.forEach(function (color) {
                $colorDropdown.append(`<option value="${color}">${color}</option>`);
            });

            Item = [...new Set(Item)];
            $itemDropdown.empty();
            $itemDropdown.append('<option value="">All Item</option>');
            Item.forEach(function (item) {
                $itemDropdown.append(`<option value="${item}">${item}</option>`);
            });

            Size = [...new Set(Size)];
            $sizeDropdown.empty();
            $sizeDropdown.append('<option value="">All Size</option>');
            Size.forEach(function (size) {
                $sizeDropdown.append(`<option value="${size}">${size}</option>`);
            });

            // Initialize DataTable for Details
            if (!ProcessItemTable) {
                ProcessItemTable = $('#ProcessItemdetailsTable').DataTable({
                    paging: false,
                    searching: true,
                    ordering: false,
                    responsive: true,
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            title: 'PROCESS PO ITEM DETAILS - ' + orderNo,
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: false
                        },
                        {
                            extend: 'pdfHtml5',
                            title: 'PROCESS PO ITEM DETAILS - ' + orderNo,
                            orientation: 'landscape',
                            pageSize: 'A4',
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: false
                        }
                    ],
                    footerCallback: function (row, data, start, end, display) {
                        calculatePoItemDetailsTotals(this.api().rows({ search: 'applied' }).data().toArray());
                    }
                });
            } else {
                ProcessItemTable.buttons().container().appendTo('#ProcessItemdetailsTable .col-md-6:eq(0)');
            }

            $SupDropdown.off('change').on('change', function () {
                const selectedSup = $(this).val();
                if (selectedSup === "") {
                    ProcessItemTable.columns(0).search('').draw(); 
                } else {
                    ProcessItemTable.columns(0).search('^' + selectedSup + '$', true, false).draw(); 
                }

                const filteredData = ProcessItemTable.rows({ search: 'applied' }).data().toArray();
                //calculateDetailsTotals(filteredData);
            });

            $ProDropdown.off('change').on('change', function () {
                const selectedPro = $(this).val();
                if (selectedPro === "") {
                    ProcessItemTable.columns(1).search('').draw(); 
                } else {
                    ProcessItemTable.columns(1).search('^' + selectedPro + '$', true, false).draw(); 
                }

                const filteredsizeData = ProcessItemTable.rows({ search: 'applied' }).data().toArray();
                //calculateDetailsTotals(filteredsizeData);
            });


            $colorDropdown.off('change').on('change', function () {
                const selectedColor = $(this).val();
                if (selectedColor === "") {
                    ProcessItemTable.columns(3).search('').draw(); 
                } else {
                    ProcessItemTable.columns(3).search('^' + selectedColor + '$', true, false).draw(); 
                }

                const filteredData = ProcessItemTable.rows({ search: 'applied' }).data().toArray();
                //calculateDetailsTotals(filteredData);
            });

            $sizeDropdown.off('change').on('change', function () {
                const selectedSize = $(this).val();
                if (selectedSize === "") {
                    ProcessItemTable.columns(4).search('').draw(); 
                } else {
                    ProcessItemTable.columns(4).search('^' + selectedSize + '$', true, false).draw(); 
                }

                const filteredsizeData = ProcessItemTable.rows({ search: 'applied' }).data().toArray();
                //calculateDetailsTotals(filteredsizeData);
            });
            $itemDropdown.off('change').on('change', function () {
                const selectedItem = $(this).val();
                if (selectedItem === "") {
                    ProcessItemTable.columns(2).search('').draw(); 
                } else {
                    ProcessItemTable.columns(2).search('^' + selectedItem + '$', true, false).draw(); 
                }

                const filtereditemData = ProcessItemTable.rows({ search: 'applied' }).data().toArray();
                //calculateDetailsTotals(filtereditemData);
            });
        }

        function populateDetailsTable(data, orderNo) {
            const $tableBody = $('#detailsTable tbody');
            const $colorDropdown = $('#colorDropdown');
            const $itemDropdown = $('#itemDropdown');
            const $sizeDropdown = $('#sizeDropdown');
            $tableBody.empty();
            let Colors = [];
            let Item = [];
            let Size = [];

            $.each(data, function (index, item) {
                Colors.push(item.Color);
                Item.push(item.Item);
                Size.push(item.Size);
                const row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.Item}</td>
                        <td>${item.Color}</td>
                        <td>${item.Size}</td>
                        <td class="sideallign">${parseInt(item.Order_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Bom_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Cut_Qty) || 0}</td>
                        <td class="sideallign">${item.To_be_Cut == 0 ? '-' : item.To_be_Cut}</td>
                        <td class="sideallign">${item.Line_Input}</td>
                        <td class="sideallign">${item.Cut_Vs_Inp == 0 ? '-' : item.Cut_Vs_Inp}</td>
                        <td class="sideallign">${parseInt(item.Sew_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Rej_Qty) == 0 ? '-' : parseInt(item.Rej_Qty) || 0}</td>
                        <td class="sideallign">${item.Inp_Vs_Outp == 0 ? '-' : item.Inp_Vs_Outp}</td>
                        <td>${item.Rej_Per}</td>
                        <td class="sideallign">${parseInt(item.Pcked_Qty) || 0}</td>
                        <td class="sideallign">${item.Ack_vs_Pck}</td>
                        <td class="sideallign">${parseInt(item.Shipped_Qty) || 0}</td>
                        <td class="sideallign">${item.Pck_Vs_Ship == 0 ? '-' : item.Pck_Vs_Ship}</td>
                        <td class="sideallign">${item.Stock_In == 0 ? '-' : item.Stock_In}</td>
                        <td class="sideallign">${item.Stock_Out == 0 ? '-' : item.Stock_Out}</td>
                    </tr>
                `;
                $tableBody.append(row);
            });

            Colors = [...new Set(Colors)];
            $colorDropdown.empty();
            $colorDropdown.append('<option value="">All Color</option>');
            Colors.forEach(function (color) {
                $colorDropdown.append(`<option value="${color}">${color}</option>`);
            });

            Item = [...new Set(Item)];
            $itemDropdown.empty();
            $itemDropdown.append('<option value="">All Item</option>');
            Item.forEach(function (item) {
                $itemDropdown.append(`<option value="${item}">${item}</option>`);
            });

            Size = [...new Set(Size)];
            $sizeDropdown.empty();
            $sizeDropdown.append('<option value="">All Size</option>');
            Size.forEach(function (size) {
                $sizeDropdown.append(`<option value="${size}">${size}</option>`);
            });

            // Initialize DataTable for Details
            if (!productionTable) {
                productionTable = $('#detailsTable').DataTable({
                    paging: false,
                    searching: true,
                    ordering: true,
                    responsive: true,
                    order: [[0, 'asc']],
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            title: 'PRODUCTION DETAILS - ' + orderNo,
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'pdfHtml5',
                            title: 'PRODUCTION DETAILS - ' + orderNo,
                            orientation: 'landscape',
                            pageSize: 'A4',
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        }
                    ],
                    footerCallback: function (row, data, start, end, display) {
                        calculateDetailsTotals(this.api().rows({ search: 'applied' }).data().toArray());
                    }
                });
            } else {
                productionTable.buttons().container().appendTo('#detailsTable .col-md-6:eq(0)');
            }

            $colorDropdown.off('change').on('change', function () {
                const selectedColor = $(this).val();
                if (selectedColor === "") {
                    productionTable.columns(2).search('').draw(); 
                } else {
                    productionTable.columns(2).search('^' + selectedColor + '$', true, false).draw(); 
                }

                const filteredData = productionTable.rows({ search: 'applied' }).data().toArray();
                calculateDetailsTotals(filteredData);
            });

            $sizeDropdown.off('change').on('change', function () {
                const selectedSize = $(this).val();
                if (selectedSize === "") {
                    productionTable.columns(3).search('').draw(); 
                } else {
                    productionTable.columns(3).search('^' + selectedSize + '$', true, false).draw(); 
                }

                const filteredsizeData = productionTable.rows({ search: 'applied' }).data().toArray();
                calculateDetailsTotals(filteredsizeData);
            });
            $itemDropdown.off('change').on('change', function () {
                const selectedItem = $(this).val();
                if (selectedItem === "") {
                    productionTable.columns(1).search('').draw(); 
                } else {
                    productionTable.columns(1).search('^' + selectedItem + '$', true, false).draw(); 
                }

                const filtereditemData = productionTable.rows({ search: 'applied' }).data().toArray();
                calculateDetailsTotals(filtereditemData);
            });
        }

        function populateAbstractTableFile(data, orderNo) {
            const $tableBody = $('#FileStatusabstractTable tbody');
            $tableBody.empty();

            $.each(data, function (index, item) {
                const row = `
                    <tr>                        
                        <td>${item.Supplier}</td>
                        <td>${item.Process}</td>
                        <td class="sideallign">${parseFloat(item.Po_Qty) || 0}</td>
                        <td class="sideallign">${parseFloat(item.Grn_Qty) || 0}</td>
                        <td class="sideallign">${parseFloat(item.Bal_Qty) || 0}</td>
                        <td class="sideallign">${(item.Pend_In_Perc) || 0}</td>
                    </tr>
                `;
                $tableBody.append(row);
            });

            // Initialize DataTable for Abstract
            if (!FileStatusabstractTable) {
                FileStatusabstractTable = $('#FileStatusabstractTable').DataTable({
                    paging: false,
                    searching: true,
                    ordering: false,
                    responsive: true,
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            title: 'PROCESS PO ABSTRACT - ' + orderNo,
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'pdfHtml5',
                            title: 'PROCESS PO ABSTRACT - ' + orderNo,
                            orientation: 'landscape',
                            pageSize: 'A4',
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        }
                    ],
                    footerCallback: function (row, data, start, end, display) {
                        //calculatePoItemDetailsTotals(this.api().rows({ search: 'applied' }).data().toArray());
                    }
                });
            } else {
                FileStatusabstractTable.buttons().container().appendTo('#FileStatusabstractTable .col-md-6:eq(0)');
            }
        }

        function populateAbstractTable(data, orderNo) {
            const $tableBody = $('#abstractTable tbody');
            $tableBody.empty();

            $.each(data, function (index, item) {
                const row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.Item}</td>
                        <td>${item.Color}</td>
                        <td class="sideallign">${parseInt(item.Order_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Bom_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Cut_Qty) || 0}</td>
                        <td class="sideallign">${item.To_be_Cut == 0 ? '-' : item.To_be_Cut}</td>
                        <td class="sideallign">${item.Line_Input}</td>
                        <td class="sideallign">${item.Cut_Vs_Inp == 0 ? '-' : item.Cut_Vs_Inp}</td>
                        <td class="sideallign">${parseInt(item.Sew_Qty) || 0}</td>
                        <td class="sideallign">${parseInt(item.Rej_Qty) == 0 ? '-' : parseInt(item.Rej_Qty) || 0}</td>
                        <td class="sideallign">${item.Inp_Vs_Outp == 0 ? '-' : item.Inp_Vs_Outp}</td>
                        <td>${item.Rej_Per}</td>
                        <td class="sideallign">${parseInt(item.Pcked_Qty) || 0}</td>
                        <td class="sideallign">${item.Ack_vs_Pck}</td>
                        <td class="sideallign">${parseInt(item.Shipped_Qty) || 0}</td>
                        <td class="sideallign">${item.Pck_Vs_Ship == 0 ? '-' : item.Pck_Vs_Ship}</td>
                        <td class="sideallign">${item.Stock_In == 0 ? '-' : item.Stock_In}</td>
                        <td class="sideallign">${item.Stock_Out == 0 ? '-' : item.Stock_Out}</td>
                    </tr>
                `;
                $tableBody.append(row);
            });

            // Initialize DataTable for Abstract
            if (!abstractTable) {
                abstractTable = $('#abstractTable').DataTable({
                    paging: false,
                    searching: true,
                    ordering: true,
                    responsive: true,
                    order: [[0, 'asc']],
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            title: 'PRODUCTION ABSTRACT - ' + orderNo,
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        },
                        {
                            extend: 'pdfHtml5',
                            title: 'PRODUCTION ABSTRACT - ' + orderNo,
                            orientation: 'landscape',
                            pageSize: 'A4',
                            exportOptions: {
                                columns: ':visible'
                            },
                            footer: true
                        }
                    ],
                    footerCallback: function (row, data, start, end, display) {
                        calculateAbstractTotals(this.api().rows({ search: 'applied' }).data().toArray());
                    }
                });
            } else {
                abstractTable.buttons().container().appendTo('#abstractTable .col-md-6:eq(0)');
            }
        }


        function calculateDetailsTotals(data) {
            let totalOrQty = 0;
            let totalBomQty = 0;
            let totalCutQty = 0;
            let totalToBeCut = 0;
            let totalLineInput = 0;
            let totalCutVsInp = 0;
            let totalSewQty = 0;
            let totalRejQty = 0;
            let totalInpVsOutp = 0;
            let totalPckedQty = 0;
            let totalAckVsPck = 0;
            let totalShippedQty = 0;
            let totalPckVsShip = 0;
            let totalStockIn = 0;
            let totalStockOut = 0;

           // console.log('Data received for details totals:', data);

            data.forEach(function (rowData) {
                totalOrQty += parseInt(rowData[4]) || 0;
                totalBomQty += parseInt(rowData[5]) || 0;
                totalCutQty += parseInt(rowData[6]) || 0;
                totalToBeCut += parseInt(rowData[7]) || 0;
                totalLineInput += parseInt(rowData[8]) || 0;
                totalCutVsInp += parseInt(rowData[9]) || 0;
                totalSewQty += parseInt(rowData[10]) || 0;
                totalRejQty += parseInt(rowData[11]) || 0;
                totalInpVsOutp += parseInt(rowData[12]) || 0;
                totalPckedQty += parseInt(rowData[14]) || 0;
                totalAckVsPck += parseInt(rowData[15]) || 0;
                totalShippedQty += parseInt(rowData[16]) || 0;
                totalPckVsShip += parseInt(rowData[17]) || 0;
                totalStockIn += parseInt(rowData[18]) || 0;
                totalStockOut += parseInt(rowData[19]) || 0;
            });

            $('#totalOrQty').text(totalOrQty);
            $('#totalBomQty').text(totalBomQty);
            $('#totalCutQty').text(totalCutQty);
            $('#totalToBeCut').text(totalToBeCut);
            $('#totalLineInput').text(totalLineInput);
            $('#totalCutVsInp').text(totalCutVsInp);
            $('#totalSewQty').text(totalSewQty);
            $('#totalRejQty').text(totalRejQty);
            $('#totalInpVsOutp').text(totalInpVsOutp);
            $('#totalPckedQty').text(totalPckedQty);
            $('#totalAckVsPck').text(totalAckVsPck);
            $('#totalShippedQty').text(totalShippedQty);
            $('#totalPckVsShip').text(totalPckVsShip);
            $('#totalStockIn').text(totalStockIn);
            $('#totalStockOut').text(totalStockOut);
        

           

        }

        function calculatePoItemDetailsTotals(data) {
            let totalOrQty1 = 0;
            let totalBomQty1 = 0;
            let totalCutQty1 = 0;
            

            data.forEach(function (rowData) {
                totalOrQty1 += parseFloat(rowData[5]) || 0;
                totalBomQty1 += parseFloat(rowData[6]) || 0;
                totalCutQty1 += parseFloat(rowData[7]) || 0;                
            });

            $('#totalOrQtyPo').text(totalOrQty1.toFixed(2));
            $('#totalBomQtyPo').text(totalBomQty1.toFixed(2));
            $('#totalCutQtyPo').text(totalCutQty1.toFixed(2));
           

        }

        function calculateAbstractTotals(data) {
            let abtotalQty = 0;
            let abtotalBomQty = 0;
            let abtotalCutQty = 0;
            let abtotalToBeCut = 0;
            let abtotalLineInput = 0;
            let abtotalCutVsInp = 0;
            let abtotalSewQty = 0;
            let abtotalRejQty = 0;
            let abtotalInpVsOutp = 0;
            let abtotalPckedQty = 0;
            let abtotalAckVsPck = 0;
            let abtotalShippedQty = 0;
            let abtotalPckVsShip = 0;
            let abtotalStockIn = 0;
            let abtotalStockOut = 0;

            //console.log('Data received for abstract totals:', data);

            
            data.forEach(function (rowData) {
                abtotalQty += parseInt(rowData[3]) || 0;
                abtotalBomQty += parseInt(rowData[4]) || 0;
                abtotalCutQty += parseInt(rowData[5]) || 0;
                abtotalToBeCut += parseInt(rowData[6]) || 0;
                abtotalLineInput += parseInt(rowData[7]) || 0;
                abtotalCutVsInp += parseInt(rowData[8]) || 0;
                abtotalSewQty += parseInt(rowData[9]) || 0;
                abtotalRejQty += parseInt(rowData[10]) || 0;
                abtotalInpVsOutp += parseInt(rowData[11]) || 0;
                abtotalPckedQty += parseInt(rowData[13]) || 0;
                abtotalAckVsPck += parseInt(rowData[14]) || 0;
                abtotalShippedQty += parseInt(rowData[15]) || 0;
                abtotalPckVsShip += parseInt(rowData[16]) || 0;
                abtotalStockIn += parseInt(rowData[17]) || 0;
                abtotalStockOut += parseInt(rowData[18]) || 0;
            });

            $('#abtotalQty').text(abtotalQty);
            $('#abtotalBomQty').text(abtotalBomQty);
            $('#abtotalCutQty').text(abtotalCutQty);
            $('#abtotalToBeCut').text(abtotalToBeCut);
            $('#abtotalLineInput').text(abtotalLineInput);
            $('#abtotalCutVsInp').text(abtotalCutVsInp);
            $('#abtotalSewQty').text(abtotalSewQty);
            $('#abtotalRejQty').text(abtotalRejQty);
            $('#abtotalInpVsOutp').text(abtotalInpVsOutp);
            $('#abtotalPckedQty').text(abtotalPckedQty);
            $('#abtotalAckVsPck').text(abtotalAckVsPck);
            $('#abtotalShippedQty').text(abtotalShippedQty);
            $('#abtotalPckVsShip').text(abtotalPckVsShip);
            $('#abtotalStockIn').text(abtotalStockIn);
            $('#abtotalStockOut').text(abtotalStockOut);

        }
    });
</script>

<!--Buyer po popup-->
<script>
    $(document).ready(function () {
        let BuyerpoTable = null; // Keep track of the DataTable instance

        $(document).on('click', '.buyerpoview', function () {
            $("#preloder").fadeIn();
            let orderNo = $(this).data('order-no');
            $('#tableModalLabelBuyerpo').text('Buyer PO STATUS - ' + orderNo);
            orderNo = orderNo.replace(/\\/g, '-');
            const apiUrl = `{{ route('buyerpostatus') }}`;

            $.ajax({
                url: apiUrl,
                method: 'GET',
                data: { orderNo: orderNo },
                contentType: 'application/json',
                success: function (response) {
                    $("#preloder").fadeOut();

                    // Check if DataTable is already initialized and destroy it
                    if ($.fn.DataTable.isDataTable('#buyerpotable')) {
                        $('#buyerpotable').DataTable().clear().destroy();
                    }

                    const thead = $('#buyerpotable thead');
                    if (thead.length === 0) {
                        $('#buyerpotable').append('<thead></thead>');
                    }
                    thead.empty();
                    
                    let Columns = [];
                    let TableHeader = "<tr>";
                    $.each(response.data[0], function (key, value) {
                        Columns.push({ "data": key });
                        TableHeader += "<th>" + key + "</th>";
                    });
                    TableHeader += "</tr>";
                    thead.append(TableHeader);

                    // Initialize the DataTable with new data
                    BuyerpoTable = $('#buyerpotable').DataTable({
                        "data": response.data,
                        "columns": Columns,
                    });
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                    $("#preloder").fadeOut();
                }
            });
        });
    });
</script>


<script>
    
    </script>




<!-- Buyer OcN -->
<script>
  $(document).ready(function () {
    // Declare buyerTable globally so it is accessible throughout the document
    
  

    let buyerTable = null;


    function BuyerocnTable(data, orderNo) {
        const $tableBody = $('#buyerorder tbody');
        const $colorDropdownbuyer = $('#colorDropdownbuyer');
        const $itemDropdownbuyer = $('#itemDropdownbuyer');
        
        $tableBody.empty();

        let Colors = [];
        let Item = [];

        

        $.each(data, function (index, item) {
            Colors.push(item.Color);
            Item.push(item.Item);

            const row = `
                <tr>
                    <td>${index + 1}</td>
                    <td>${item.Operation}</td>
                    <td>${item.Mch_Type}</td>
                    <td>${item.OP_TYPE}</td>
                    <td>${item.Grade}</td>
                    <td>${item.Seconds}</td>
                    <td>${item.Minutes}</td>                        
                    <td>${item.Req_Oper}</td>                        
                    <td>${item.Allot_Oper}</td>                        
                    <td>${item.Cost}</td>                        
                    <td>${item.Color}</td>                        
                    <td>${item.Item}</td>                    
                </tr>
            `;
            $tableBody.append(row);
        });

        // Remove duplicates from Colors and Items arrays
        Colors = [...new Set(Colors)];
        $colorDropdownbuyer.empty();
        $colorDropdownbuyer.append('<option value="">All Color</option>');
        Colors.forEach(function (color) {
            $colorDropdownbuyer.append(`<option value="${color}">${color}</option>`);
        });

        Item = [...new Set(Item)];
        $itemDropdownbuyer.empty();
        $itemDropdownbuyer.append('<option value="">All Item</option>');
        Item.forEach(function (item) {
            $itemDropdownbuyer.append(`<option value="${item}">${item}</option>`);
        });

        // Initialize DataTable for the first time (if not already initialized)
        if (buyerTable === null) {
            buyerTable = $('#buyerorder').DataTable({
                paging: false,
                searching: true,
                ordering: false,
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Buyer DETAILS - ' + orderNo,
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: false
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'Buyer DETAILS - ' + orderNo,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: false
                    }
                ],
                footerCallback: function (row, data, start, end, display) {
                    calculatebuyerDetailsTotals(this.api().rows({ search: 'applied' }).data().toArray());
                }
            });
        } else {
            buyerTable.buttons().container().appendTo('#buyerorder');
        }

        // Filter by color dropdown
        $colorDropdownbuyer.off('change').on('change', function () {
            const selectedColoras = $(this).val();

            alert($(this).val());

            if (selectedColoras === "") {
                buyerTable.columns(10).search('').draw(); // Clear color filter
            } else {
                buyerTable.columns(10).search('^' + selectedColoras + '$', true, false).draw(); // Apply color filter
            }

            const filteredData = buyerTable.rows({ search: 'applied' }).data().toArray();
            calculatebuyerDetailsTotals(filteredData);
        });


        let debounceTimeout = null;

$colorDropdownbuyer.off('change').on('change', function () {
    clearTimeout(debounceTimeout);
    debounceTimeout = setTimeout(function () {
        const selectedColor = $colorDropdownbuyer.val();
        if (selectedColor === "") {
            // "All Color" selected, clear the color filter
            buyerTable.columns(10).search('').draw();
        } else {
            // Apply the color filter
            buyerTable.columns(10).search('^' + selectedColor + '$', true, false).draw();
        }

        // Recalculate totals after filtering
        const filteredData = buyerTable.rows({ search: 'applied' }).data().toArray();
        calculatebuyerDetailsTotals(filteredData);
    }, 300); // Delay for 300ms
});

        // Filter by item dropdown
        $itemDropdownbuyer.off('change').on('change', function () {
            const selectedItemAS = $(this).val();
            console.log(selectedItemAS);
            if (selectedItemAS === "") {
                buyerTable.columns(11).search('').draw(); // Clear item filter
            } else {
                buyerTable.columns(11).search('^' + selectedItemAS + '$', true, false).draw(); // Apply item filter
            }

            const sizededData = buyerTable.rows({ search: 'applied' }).data().toArray();
            calculatebuyerDetailsTotals(sizededData);
        });
    }

    // Function to calculate and update totals
    function calculatebuyerDetailsTotals(data) {
        let totalseconds = 0;
        let totalminis = 0;
        let totalreqoper = 0;
        let totalalloper = 0;
        let totalcost = 0;

        data.forEach(function (rowData) {
            totalseconds += parseFloat(rowData[5]) || 0;
            totalminis += parseFloat(rowData[6]) || 0;
            totalreqoper += parseFloat(rowData[7]) || 0;
            totalalloper += parseFloat(rowData[8]) || 0;
            totalcost += parseFloat(rowData[9]) || 0;
        });

        $('#totalseconds').text(parseFloat(totalseconds).toFixed(2));
        $('#totalminis').text(parseFloat(totalminis).toFixed(2));
        $('#totalreqoper').text(parseFloat(totalreqoper).toFixed(2));
        $('#totalalloper').text(parseFloat(totalalloper).toFixed(2));
        $('#totalcost').text(parseFloat(totalcost).toFixed(2));
    }

// Function to initialize the DataTable
$(document).on('click', '.buyer-popup', function () {
    $("#preloder").fadeIn();
    let orderNo = $(this).data('order-no');
    orderNo = orderNo.replace(/\\/g, '-');
    const apiUrl = `{{ route('buyerorderstatus') }}`;

    $.ajax({
        url: apiUrl,
        method: 'GET',
        data: { orderNo: orderNo },
        contentType: 'application/json',
        success: function (response) {
            $("#preloder").fadeOut();
            if (response.success) {
                BuyerocnTable(response.data, orderNo);
            } else {
                console.error('Error fetching data:', response.message);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            $("#preloder").fadeOut();
        }
    });

    if ($.fn.dataTable.isDataTable('#buyerorder')) {
        return; 
    }

   
});

   

    // Example of how to handle closing the modal (if that's where the error is triggered)
    $('#tableModalbuyer').on('hidden.bs.modal', function () {
        // Check if buyerTable is defined and initialized
        if (buyerTable) {
            // Optionally destroy or reset the DataTable here if necessary
            buyerTable.clear().draw(); // Clear data (if you want to reset the table on close)
        }
    });
});




</script>

<!--supplier po popup-->
<script>

$(document).ready(function () {
    let poTable = null;

    $(document).on('click', '.poview', function () {
        $("#preloder").fadeIn();
        let orderNo = $(this).data('order-no');
        $('#tableModalLabelpo').text('RAW MATERIAL STATUS - ' + orderNo);
        orderNo = orderNo.replace(/\\/g, '-');

        const apiUrl = `{{ route('rawmaterialstatus') }}`;

       // console.log('Fetching data from:', apiUrl);

        $.ajax({
            url: apiUrl,
            method: 'GET',
            data:{orderNo:orderNo},
            contentType: 'application/json',
            success: function (data) {
                $("#preloder").fadeOut();
                if (data.success) {
                    populateTable(data.data, orderNo);
                } else {
                    console.error('Error fetching data:', data.message);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });

    $('#tableModalpo').on('hidden.bs.modal', function () {
        if (poTable) {
            poTable.destroy();
            poTable = null;
        }
        $('#tableModalpo tbody').empty(); 
    });

    

    function populateTable(data, orderNo) {
        const $tableBody = $('#tableModalpo tbody');
        $tableBody.empty(); // Clear the table body

        
        const currentoriginalDate = new Date();
        const currentDay = currentoriginalDate.getDate().toString().padStart(2, '0');
        const currentMonth = (currentoriginalDate.getMonth() + 1).toString().padStart(2, '0');
        const currentYear = currentoriginalDate.getFullYear();
        const currentDateFormatted = `${currentDay}-${currentMonth}-${currentYear}`;

        $.each(data, function (index, item) {
            const poOriginalDate = new Date(item.Po_Date);
            const poDay = poOriginalDate.getDate().toString().padStart(2, '0');
            const poMonth = (poOriginalDate.getMonth() + 1).toString().padStart(2, '0');
            const poYear = poOriginalDate.getFullYear();
            const formattedPoDate = `${poDay}-${poMonth}-${poYear}`;

            const planOriginalDate = new Date(item.Plan_Date);
            const planDay = planOriginalDate.getDate().toString().padStart(2, '0');
            const planMonth = (planOriginalDate.getMonth() + 1).toString().padStart(2, '0');
            const planYear = planOriginalDate.getFullYear();
            const formattedPlanDate = `${planDay}-${planMonth}-${planYear}`;


            

            let rowClass = '';
            if (item.To_be_Ordered != 0) {
                if (planOriginalDate === currentoriginalDate) {
                    rowClass = 'highlight-green';
                   
                } 
                else if (planOriginalDate > currentoriginalDate) {
                    rowClass = 'highlight-green';

                } else if (planOriginalDate < currentoriginalDate) {
                    rowClass = 'highlight-red';

                }
            }


            const row = `
                <tr>
                    <td class="${rowClass}">${index + 1}</td>
                    <td class="${rowClass}">${item.Item}</td>
                    <td class="${rowClass}">${item.Item_Type}</td>
                    <td class="${rowClass}">${item.Color}</td>
                    <td class="${rowClass}">${item.Size}</td>
                    <td class="sideallign ${rowClass}">${parseInt(item.Req_Qty) || 0} ${item.Uom.toLowerCase()}</td>
                    <td class="sideallign ${rowClass}">${parseInt(item.Recvd_Qty) || 0}</td>
                    <td class="sideallign ${rowClass}">${item.To_be_Ordered == 0 ? '-' : item.To_be_Ordered}</td>
                    <td class="sideallign ${rowClass}">${item.To_be_Recvd == 0 ? '-' : item.To_be_Recvd}</td>
                    <td class="sideallign ${rowClass}">${item.Issued == 0 ? '-' : item.Issued}</td>
                    <td class="${rowClass}">${item.Stock == 0 ? '-' : item.Stock}</td>
                    <td class="${rowClass}">${item.Supplier}</td>
                    <td class="${rowClass}">${item.Po_No ? item.Po_No : '-'}</td>
                    <td class="sideallign ${rowClass}">${formattedPoDate === '01-01-1970' ? '-' : formattedPoDate}</td>
                    <td class="sideallign ${rowClass}">${formattedPlanDate === '01-01-1970' ? '-' : formattedPlanDate}</td>
                    <td class="sideallign ${rowClass}">${parseInt(item.Sup_Po_Qty) || 0}</td>
                </tr>
            `;

            $tableBody.append(row);
        });

        // Initialize DataTable if not already initialized
        if (!poTable) {
            poTable = $('#tableModalpo table').DataTable({
                paging: false,
                searching: true,
                ordering: true,
                order: [[0, 'asc']],
                dom: 'Bfrtip',
                columnDefs: [
                {
                    targets: [13,14], 
                    type: 'date-dd-mm-yyyy'  
                },
                
            ],
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'RAW MATERIAL STATUS - ' + orderNo,
                        exportOptions: {
                    format: {
                        body: function(data, row, column, node) {
                            // Use moment.js to convert dd-mm-   yyyy to ISO date format yyyy-mm-dd for Excel


                            if ((column === 13 || column === 14) && /\d{2}-\d{2}-\d{4}/.test(data)) {
                                // Convert date to 'dd/mm/yyyy'
                                return moment(data, 'DD-MM-YYYY').format('YYYY-MM-DD');
                            } else {
                                // For other columns, return the data without changes
                                return $('<div>').html(data).text(); // Strips any HTML tags if present
                            }
                        }
                    }
                },
                        footer: true
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'RAW MATERIAL STATUS - ' + orderNo,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        exportOptions: {
                            columns: ':visible'
                        },
                        footer: true
                    }
                ],
                footerCallback: function (row, data, start, end, display) {
                    let totalReqQty = 0;
                    let totalGrnQty = 0;
                    let totalToBeOrd = 0;
                    let totalToBeRcvd = 0;
                    let totalIssued = 0;
                    let totalStock = 0;
                    let totalPoQty = 0;

                    data.forEach(function (rowData) {
                        totalReqQty += parseInt(rowData[5].replace(/[^\d.-]/g, '')) || 0;
                        totalGrnQty += parseInt(rowData[6].replace(/[^\d.-]/g, '')) || 0;
                        totalToBeOrd += parseInt(rowData[7].replace(/[^\d.-]/g, '')) || 0;
                        totalToBeRcvd += parseInt(rowData[8].replace(/[^\d.-]/g, '')) || 0;
                        totalIssued += parseInt(rowData[9].replace(/[^\d.-]/g, '')) || 0;
                        totalStock += parseInt(rowData[10].replace(/[^\d.-]/g, '')) || 0;
                        totalPoQty += parseInt(rowData[15].replace(/[^\d.-]/g, '')) || 0;
                    });

                    $('#Req_Qty').text(totalReqQty);
                    $('#Grn_Qty').text(totalGrnQty);
                    $('#To_Be_Ord').text(totalToBeOrd);
                    $('#To_Be_Rcvd').text(totalToBeRcvd);
                    $('#Issued').text(totalIssued);
                    $('#Stock').text(totalStock);
                    $('#Po_Qty').text(totalPoQty);
                }
            });
        }
    }
});

</script>

<!--T & A details popup-->
<script>
   $(document).ready(function () {
    let taTable = null;

    $(document).on('click', '.tadetails', function () {
        $("#preloder").fadeIn();
        let orderNo = $(this).data('order-no');
        $('#tableModalLabelta').text('T & A Details - ' + orderNo);
        orderNo = orderNo.replace(/\\/g, '-');

        const apiUrl = `{{ route('timetoaction') }}`;

       // console.log('Fetching data from:', apiUrl);

        $.ajax({
            url: apiUrl,
            method: 'GET',
            data:{orderNo:orderNo},
            contentType: 'application/json',
            success: function (data) {
                $("#preloder").fadeOut();
                if (data.success) {
                    populateTable(data.data, orderNo);
                } else {
                    console.error('Error fetching data:', data.message);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });

    $('#tableModalta').on('hidden.bs.modal', function () {
        if (taTable) {
            taTable.destroy();
            taTable = null;
        }
        $('#tableModalta tbody').empty();
        $('#totalQty').text('');
    });

    function populateTable(data, orderNo) {
        const $tableBody = $('#tableModalta tbody');
        $tableBody.empty();

          $.each(data, function (index, item) {
            const StartDate = new Date(item.SDate);
            const FinishDate = new Date(item.FDate);
            const ActualFDate = '';
            const  ActualSDate = '';


            // Format the Start Date to dd-mm-yyyy
            const SDate = `${StartDate.getDate().toString().padStart(2, '0')}-${(StartDate.getMonth() + 1).toString().padStart(2, '0')}-${StartDate.getFullYear()}`;

            // Format the Finish Date to dd-mm-yyyy
            const FDate = `${FinishDate.getDate().toString().padStart(2, '0')}-${(FinishDate.getMonth() + 1).toString().padStart(2, '0')}-${FinishDate.getFullYear()}`;
        if(item.Actual_SDate != null){
    const Actual_StartDate = new Date(item.Actual_SDate);
    const ActualSDate = `${Actual_StartDate.getDate().toString().padStart(2, '0')}-${(Actual_StartDate.getMonth() + 1).toString().padStart(2, '0')}-${Actual_StartDate.getFullYear()}`;



        }if(item.Actual_FDate != null){
    const  Actual_FinishDate = new Date(item.Actual_FDate);
    const ActualFDate = `${Actual_FinishDate.getDate().toString().padStart(2, '0')}-${(Actual_FinishDate.getMonth() + 1).toString().padStart(2, '0')}-${Actual_FinishDate.getFullYear()}`;
      
    }

    // Format the Finish Date to dd-mm-yyyy

            const qty = parseInt(item.Qty) || 0;
            const Actualqty = parseInt(item.Actual_Qty) || 0;



            const row = `
                <tr>
                    <td>${index + 1}</td>
                    <td>${item.Type}</td>
                    <td>${item.Task}</td>
                    <td class="sideallign">${qty}</td>
                    <td class="sideallign">${SDate}</td>
                    <td class="sideallign">${FDate}</td>
                    <td class="sideallign">${Actualqty}</td>
                    <td class="sideallign">${ActualSDate}</td>
                    <td class="sideallign">${ActualFDate}</td>
                    <td>${item.Resources}</td>
                    <td>${item.Duration}</td>
                </tr>
            `;
            $tableBody.append(row);
        });

        if (!taTable) {
            taTable = $('#tableModalta table').DataTable({
                paging: false,
                searching: true,
                ordering: true,
                order: [[0, 'asc']],
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'T & A Details - ' + orderNo,
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'T & A Details - ' + orderNo,
                        orientation: 'landscape',
                        pageSize: 'A4',
                        exportOptions: {
                            columns: ':visible'
                        }
                    }
                ],
                footerCallback: function (row, data, start, end, display) {
                    let api = this.api();
                    let totalQty = api.column(3, { search: 'applied' }).data().reduce(function (a, b) {
                        return (parseInt(a) || 0) + (parseInt(b) || 0);
                    }, 0);

                    $(api.column(3).footer()).html(totalQty);
                },
                createdRow: function (row, data, dataIndex) {
                    //console.log('Data at index 7:', data[7]);
            if (data[7] == 1) {
                $(row).addClass("greencolor");
            }
        }
            });
        } else {
            taTable.clear().rows.add($tableBody.find('tr')).draw();
        }
    }
});



function formatDateCk(dateString) {

//console.log(dateString);
if (!dateString || typeof dateString !== 'string') {
    return '';  // Handle invalid date input
}

var parts = dateString.split("-");
if (parts.length === 3) {
    var day = parts[2];
    var month = parts[1];
    var year = parts[0];

    if (year && year.length === 4) {
        var shortYear = year.substring(2);  // Extract last two digits of the year
        return day + '-' + month + '-' + shortYear;
    } else {
        return '';  // Handle incorrect year length
    }
} else {
    return '';  // Handle incorrect date format
}
}
function formatIndianNumber1(x) {
        var parts = x.toString().split(".");
        var lastThree = parts[0].slice(-3);
        var otherNumbers = parts[0].slice(0, -3);
        if (otherNumbers !== '') {
            lastThree = ',' + lastThree;
        }
        return formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
        //return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
    }
</script>
@endsection



